package com.anplus.hr.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.cola.dto.PageResponse;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import top.binfast.common.core.util.MapstructUtils;
import top.binfast.common.mybatis.util.QueryUtil;
import com.anplus.hr.domain.EmployeeLaborCost;
import com.anplus.hr.domain.vo.EmployeeLaborCostVo;
import com.anplus.hr.domain.params.EmployeeLaborCostListParam;
import com.anplus.hr.domain.params.EmployeeLaborCostParam;
import com.anplus.hr.mapper.EmployeeLaborCostMapper;
import com.anplus.hr.service.EmployeeLaborCostServ;

import java.util.List;

/**
 * 人工成本档案Service业务层处理
 *
 * @author LiuBin
 * @date 2025-12-09
 */
@RequiredArgsConstructor
@Service
public class EmployeeLaborCostServImpl extends ServiceImpl<EmployeeLaborCostMapper, EmployeeLaborCost> implements EmployeeLaborCostServ {

    private final EmployeeLaborCostMapper employeeLaborCostMapper;

    /**
     * 分页查询人工成本档案列表
     *
     * @param param 查询条件
     * @return 人工成本档案分页列表
     */
    @Override
    public PageResponse<EmployeeLaborCostVo> queryPageList(EmployeeLaborCostListParam param) {
        Page<EmployeeLaborCost> page = QueryUtil.getPage(param);
        LambdaQueryWrapper<EmployeeLaborCost> lambdaQuery = this.buildQueryWrapper(param);
        employeeLaborCostMapper.selectPage(page, lambdaQuery);
        return QueryUtil.getPageResponse(page, MapstructUtils.convert(page.getRecords(), EmployeeLaborCostVo.class));
    }


    /**
     * 查询符合条件的人工成本档案列表
     *
     * @param param 查询条件
     * @return 人工成本档案列表
     */
    @Override
    public List<EmployeeLaborCostVo> queryList(EmployeeLaborCostListParam param) {
        LambdaQueryWrapper<EmployeeLaborCost> lambdaQuery = this.buildQueryWrapper(param);
        return MapstructUtils.convert(employeeLaborCostMapper.selectList(lambdaQuery), EmployeeLaborCostVo.class);
    }

    private LambdaQueryWrapper<EmployeeLaborCost> buildQueryWrapper(EmployeeLaborCostListParam param) {
        LambdaQueryWrapper<EmployeeLaborCost> lambdaQuery = Wrappers.<EmployeeLaborCost>lambdaQuery();
        lambdaQuery.orderByDesc(EmployeeLaborCost::getId);
        lambdaQuery.eq(param.getRecordDate() != null, EmployeeLaborCost::getRecordDate, param.getRecordDate());
        lambdaQuery.eq(param.getOssId() != null, EmployeeLaborCost::getOssId, param.getOssId());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getFileKey()), EmployeeLaborCost::getFileKey, param.getFileKey());
        return lambdaQuery;
    }

    /**
     * 查询人工成本档案
     *
     * @param id 主键
     * @return 人工成本档案
     */
    @Override
    public EmployeeLaborCostVo queryById(Long id){
        EmployeeLaborCost employeeLaborCost = employeeLaborCostMapper.selectById(id);
        return MapstructUtils.convert(employeeLaborCost, EmployeeLaborCostVo.class);
    }

    /**
     * 新增人工成本档案
     *
     * @param param 人工成本档案
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByParam(EmployeeLaborCostParam param) {
        EmployeeLaborCost employeeLaborCost = MapstructUtils.convert(param, EmployeeLaborCost.class);
        return this.save(employeeLaborCost);
    }

    /**
     * 修改人工成本档案
     *
     * @param param 人工成本档案
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByParam(EmployeeLaborCostParam param) {
        EmployeeLaborCost employeeLaborCost = MapstructUtils.convert(param, EmployeeLaborCost.class);
        return this.updateById(employeeLaborCost);
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(EmployeeLaborCost entity){
        // 做一些数据校验,如唯一约束
    }

    /**
     * 校验并批量删除人工成本档案信息
     *
     * @param ids 待删除的主键集合
     * @return 是否删除成功
     */
    @Override
//    @Transactional(rollbackFor = {Exception.class})
    public Boolean delByIds(List<Long> ids) {
        //做一些业务上的校验,判断是否需要校验
        return this.removeByIds(ids);
    }
}
