package com.anplus.hr.service.impl;

import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.vo.EmployeeInfoVo;
import lombok.RequiredArgsConstructor;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import top.binfast.app.biz.sysapi.bean.model.oss.SysOss;
import top.binfast.app.biz.sysapi.dao.system.SysOssMapper;
import top.binfast.common.oss.core.OssService;
import top.binfast.common.oss.enums.AccessPolicyType;

import java.util.Date;
import java.util.List;

/**
 * @author 刘斌
 * @date 2025/11/17 10:35
 */
@Component
@RequiredArgsConstructor
public class EmployeeAsyncService {

    private final SysOssMapper sysOssMapper;
    private final OssService ossService;

    @Async
    public void saveOssBatch(List<SysOss> ossList) {
        sysOssMapper.insert(ossList);
    }

    /**
     * 生成临时URL
     *
     * @param employeeInfoVo
     * @return
     */
    public EmployeeInfoVo matchingUrl(EmployeeInfoVo employeeInfoVo) {
//        OssClient storage = OssFactory.instance(oss.getService());
        // 仅修改桶类型为 private 的URL，临时URL时长为300s
        if (employeeInfoVo.getPhoto() == null) {
            return employeeInfoVo;
        }
        Date expiration = new Date(new Date().getTime() + 300 * 1000L);
        if (AccessPolicyType.PRIVATE == ossService.getAccessPolicy()) {
            employeeInfoVo.setPhoto(ossService.getPrivateUrl(employeeInfoVo.getPhoto(), expiration));
        }
        return employeeInfoVo;
    }
}
