package com.anplus.hr.service;

import com.alibaba.cola.dto.PageResponse;
import com.alibaba.cola.dto.Response;
import com.anplus.hr.domain.InterviewProfile;
import com.anplus.hr.domain.params.InterviewProfileListParam;
import com.anplus.hr.domain.params.InterviewProfileParam;
import com.anplus.hr.domain.vo.InterviewProfileImportVo;
import com.anplus.hr.domain.vo.InterviewProfileVo;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;
import java.util.stream.Stream;

/**
 * 面试档案Service接口
 *
 * @author LiuBin
 * @date 2025-12-08
 */
public interface InterviewProfileServ extends IService<InterviewProfile> {


    /**
     * 分页查询面试档案列表
     *
     * @param param 查询条件
     * @return 面试档案分页列表
     */
    PageResponse<InterviewProfileVo> queryPageList(InterviewProfileListParam param);

    /**
     * 查询符合条件的面试档案列表
     *
     * @param param 查询条件
     * @return 面试档案列表
     */
    List<InterviewProfileVo> queryList(InterviewProfileListParam param);

    /**
     * 导入数据
     *
     * @param list 数据列表
     * @return 是否导入成功
     */
    Response importInterviewList(Stream<InterviewProfileImportVo> list);

    /**
     * 查询面试档案
     *
     * @param id 主键
     * @return 面试档案
     */
    InterviewProfileVo queryById(Long id);

    /**
     * 新增面试档案
     *
     * @param param 面试档案
     * @return 是否新增成功
     */
    Boolean insertByParam(InterviewProfileParam param);

    /**
     * 修改面试档案
     *
     * @param param 面试档案
     * @return 是否修改成功
     */
    Boolean updateByParam(InterviewProfileParam param);

    /**
     * 校验并批量删除面试档案信息
     *
     * @param ids 待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

}
