package com.anplus.hr.service;

import com.anplus.hr.domain.EmployeeLaborCost;
import com.anplus.hr.domain.vo.EmployeeLaborCostVo;
import com.anplus.hr.domain.params.EmployeeLaborCostListParam;
import com.anplus.hr.domain.params.EmployeeLaborCostParam;
import com.alibaba.cola.dto.PageResponse;
import com.baomidou.mybatisplus.extension.service.IService;
import java.util.List;

/**
 * 人工成本档案Service接口
 *
 * @author LiuBin
 * @date 2025-12-09
 */
public interface EmployeeLaborCostServ extends IService<EmployeeLaborCost> {


    /**
     * 分页查询人工成本档案列表
     *
     * @param param        查询条件
     * @return 人工成本档案分页列表
     */
    PageResponse<EmployeeLaborCostVo> queryPageList(EmployeeLaborCostListParam param);

    /**
     * 查询符合条件的人工成本档案列表
     *
     * @param param 查询条件
     * @return 人工成本档案列表
     */
    List<EmployeeLaborCostVo> queryList(EmployeeLaborCostListParam param);

    /**
     * 查询人工成本档案
     *
     * @param id 主键
     * @return 人工成本档案
     */
     EmployeeLaborCostVo queryById(Long id);

    /**
     * 新增人工成本档案
     *
     * @param param 人工成本档案
     * @return 是否新增成功
     */
    Boolean insertByParam(EmployeeLaborCostParam param);

    /**
     * 修改人工成本档案
     *
     * @param param 人工成本档案
     * @return 是否修改成功
     */
    Boolean updateByParam(EmployeeLaborCostParam param);

    /**
     * 校验并批量删除人工成本档案信息
     *
     * @param ids     待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

}
