package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import cn.idev.excel.annotation.write.style.*;
import cn.idev.excel.enums.poi.FillPatternTypeEnum;
import com.anplus.hr.constant.HrConstant;
import com.anplus.hr.domain.InterviewProfile;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Getter;
import lombok.Setter;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.bean.ExcelBaseEntity;
import top.binfast.common.excel.converters.ExcelDictConvert;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author 刘斌
 * @date 2025/12/8 10:04
 */
@Getter
@ExcelIgnoreUnannotated
@ContentRowHeight(20)
@HeadRowHeight(25)
@ColumnWidth(20)
//IndexedColors.SKY_BLUE.getIndex()
@HeadStyle(fillPatternType = FillPatternTypeEnum.SOLID_FOREGROUND, fillForegroundColor = 40)
@HeadFontStyle(color = 9, fontHeightInPoints = 11)
@AutoMapper(target = InterviewProfile.class, reverseConvertGenerate = false)
public class InterviewProfileImportVo extends ExcelBaseEntity implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 招揽岗位
     */
    @ExcelProperty(value = "招揽岗位")
    private String jobPosition;

    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名")
    private String name;

    /**
     * 身份证号
     */
    @ExcelProperty(value = "身份证号")
    private String idCardNumber;

    /**
     * 性别
     */
    @ExcelProperty(value = "性别")
    private String gender;

    /**
     * 学历
     */
    @ExcelProperty(value = "学历")
    private String education;

    /**
     * 标杆企业
     */
    @ExcelProperty(value = "标杆企业")
    private String benchmarkEnterprise;

    /**
     * 院校
     */
    @ExcelProperty(value = "院校")
    private String school;

    /**
     * 专业
     */
    @ExcelProperty(value = "专业")
    private String major;

    /**
     * 联系方式
     */
    @ExcelProperty(value = "联系方式")
    private String phoneNumber;

    /**
     * 面试时间
     */
    @Setter
    @ExcelProperty(value = "面试时间")
    private LocalDate interviewDate;

    /**
     * 面试情况
     */
    @ExcelProperty(value = "面试情况")
    private String interviewSituation;

    /**
     * 面试结果
     */
    @ExcelProperty(value = "面试结果", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_INTERVIEW_RESULT)
    private String interviewResult;

    public void setJobPosition(String jobPosition) {
        this.jobPosition = jobPosition == null ? null : jobPosition.trim();
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public void setGender(String gender) {
        this.gender = gender == null ? null : gender.trim();
    }

    public void setIdCardNumber(String idCardNumber) {
        this.idCardNumber = idCardNumber == null ? null : idCardNumber.trim();
    }

    public void setEducation(String education) {
        this.education = education == null ? null : education.trim();
    }

    public void setSchool(String school) {
        this.school = school == null ? null : school.trim();
    }

    public void setMajor(String major) {
        this.major = major == null ? null : major.trim();
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber == null ? null : phoneNumber.trim();
    }

    public void setBenchmarkEnterprise(String benchmarkEnterprise) {
        this.benchmarkEnterprise = benchmarkEnterprise == null ? null : benchmarkEnterprise.trim();
    }

    public void setInterviewSituation(String interviewSituation) {
        this.interviewSituation = interviewSituation == null ? null : interviewSituation.trim();
    }

    public void setInterviewResult(String interviewResult) {
        this.interviewResult = interviewResult == null ? null : interviewResult.trim();
    }
}
