package com.anplus.hr.domain.vo;

import java.time.LocalDate;

import com.anplus.hr.constant.HrConstant;
import com.anplus.hr.domain.EmployeeInfo;
import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import cn.idev.excel.annotation.ExcelIgnore;
import org.dromara.core.trans.anno.Trans;
import org.dromara.core.trans.constant.TransType;
import org.dromara.core.trans.vo.TransPojo;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import top.binfast.common.excel.converters.ExcelUrlImageConverter;

import java.io.Serial;
import java.io.Serializable;



/**
 * 兼职员工信息视图对象 employee_part_time_info
 *
 * @author LiuBin
 * @date 2025-12-10
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = EmployeeInfo.class)
public class EmployeePartTimeInfoVo implements TransPojo, Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 序号
     */
    private Long id;

    /**
     * 板块
     */
    @ExcelProperty(value = "板块")
    private String plate;

    /**
     * 一级部门
     */
    @ExcelProperty(value = "一级部门")
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @ExcelProperty(value = "二级部门")
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    @ExcelProperty(value = "三级部门")
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    @ExcelProperty(value = "部门ID")
    private Long deptId;

    /**
     * 岗位类型
     */
    @ExcelProperty(value = "岗位类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_POSITION_TYPE)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_POSITION_TYPE)
    private String positionType;

    /**
     * 主岗位
     */
    @ExcelProperty(value = "主岗位")
    private String position;

    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名")
    private String name;

    /**
     * 性别
     */
    @ExcelProperty(value = "性别", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_USER_SEX)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_USER_SEX)
    private String gender;

    /**
     * 身份证号码
     */
    @ExcelProperty(value = "身份证号码")
    private String idCardNumber;

    /**
     * OSS_ID
     */
    @ExcelIgnore
    private Long ossId;

    /**
     * 照片
     */
    @ExcelProperty(value = "照片", converter = ExcelUrlImageConverter.class)
    private String photo;

    /**
     * 出生日期
     */
    @ExcelProperty(value = "出生日期")
    private LocalDate birthDate;

    /**
     * 年龄
     */
    @ExcelProperty(value = "年龄")
    private Integer age;

    /**
     * 年龄段
     */
    @ExcelProperty(value = "年龄段", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_AGE_GROUP)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_AGE_GROUP)
    private String ageGroup;

    /**
     * 籍贯
     */
    @ExcelProperty(value = "籍贯")
    private String nativePlace;

    /**
     * 民族
     */
    @ExcelProperty(value = "民族")
    private String ethnicity;

    /**
     * 婚姻状况
     */
    @ExcelProperty(value = "婚姻状况", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_MARITAL_STATUS)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_MARITAL_STATUS)
    private String maritalStatus;

    /**
     * 政治面貌
     */
    @ExcelProperty(value = "政治面貌", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_POLITICAL_STATUS)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_POLITICAL_STATUS)
    private String politicalStatus;

    /**
     * 手机号码
     */
    @ExcelProperty(value = "手机号码")
    private String phoneNumber;

    /**
     * 紧急联系人
     */
    @ExcelProperty(value = "紧急联系人")
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    @ExcelProperty(value = "紧急联系人电话")
    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    @ExcelProperty(value = "家庭地址")
    private String homeAddress;

    /**
     * 入职时间
     */
    @ExcelProperty(value = "入职时间")
    private LocalDate entryDate;

    /**
     * 全日制学历
     */
    @ExcelProperty(value = "全日制学历")
    private String fulltimeEducation;

    /**
     * 全日制毕业院校
     */
    @ExcelProperty(value = "全日制毕业院校")
    private String fulltimeSchool;

    /**
     * 全日制专业
     */
    @ExcelProperty(value = "全日制专业")
    private String fulltimeMajor;

    /**
     * 全日制毕业日期
     */
    @ExcelProperty(value = "全日制毕业日期")
    private LocalDate fulltimeGraduationDate;

    /**
     * 全日制学位
     */
    @ExcelProperty(value = "全日制学位")
    private String fulltimeDegree;

    /**
     * 用工形式
     */
    @ExcelProperty(value = "用工形式", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_EMPLOYMENT_FORM)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_EMPLOYMENT_FORM)
    private String employmentForm;

    /**
     * 是否兼职
     */
//    @ExcelProperty(value = "是否兼职")
    private String partTimeFlag;

    /**
     * 签订兼职协议
     */
    @ExcelProperty(value = "签订兼职协议", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.SYS_YES_NO)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.SYS_YES_NO)
    private String partTimeAgreement;

    /**
     * 协议主体
     */
    @ExcelProperty(value = "协议主体")
    private String agreementEntity;

    /**
     * 协议期限
     */
    @ExcelProperty(value = "协议期限")
    private String agreementPeriod;

    /**
     * 协议开始时间
     */
    @ExcelProperty(value = "协议开始时间")
    private LocalDate agreementStartDate;

    /**
     * 协议截止时间
     */
    @ExcelProperty(value = "协议截止时间")
    private LocalDate agreementEndDate;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remarks;

    /**
     * 银行卡号
     */
    @ExcelProperty(value = "银行卡号")
    private String bankCardNumber;

    /**
     * 开户行
     */
    @ExcelProperty(value = "开户行")
    private String bankName;

    /**
     * 公司内是否有亲属关系
     */
    @ExcelProperty(value = "公司内是否有亲属关系", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.SYS_YES_NO)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.SYS_YES_NO)
    private String hasRelativeInCompany;

    /**
     * 亲属姓名
     */
    @ExcelProperty(value = "亲属姓名")
    private String relativeName;

    /**
     * 介绍人
     */
    @ExcelProperty(value = "介绍人")
    private String introducer;

    /**
     * 介绍人关系
     */
    @ExcelProperty(value = "介绍人关系")
    private String introducerRelation;

    /**
     * 工资发放地
     */
    @ExcelProperty(value = "工资发放地")
    private String salaryLocation;

    /**
     * 成本费用所属
     */
    @ExcelProperty(value = "成本费用所属")
    private String costOfDept;

    /**
     * 员工状态
     */
    private Integer status;


}
