package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.constant.HrConstant;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.EmployeePartTimeInfoParam;
import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import jakarta.validation.constraints.NotBlank;
import lombok.Getter;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.bean.ExcelBaseEntity;
import top.binfast.common.excel.converters.ExcelDictConvert;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author 刘斌
 * @date 2025/12/11 15:53
 */
@Getter
@AutoMappers({
        @AutoMapper(target = EmployeeInfo.class, reverseConvertGenerate = false),
        @AutoMapper(target = EmployeeInfoImportVo.class, reverseConvertGenerate = false)
})
public class EmployeePartTimeInfoImportVo extends ExcelBaseEntity implements Serializable {
    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 板块
     */
    @NotBlank(message = "板块不能为空", groups = {AddGroup.class})
    @ExcelProperty(value = "板块")
    private String plate;

    /**
     * 一级部门
     */
    @NotBlank(message = "一级部门不能为空", groups = {AddGroup.class})
    @ExcelProperty(value = "一级部门")
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @ExcelProperty(value = "二级部门")
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    @ExcelProperty(value = "三级部门")
    private String thirdLevelDepartment;

//    /**
//     * 部门ID
//     */
//    @ExcelProperty(value = "部门ID")
//    private Long deptId;

    /**
     * 岗位类型
     */
    @ExcelProperty(value = "岗位类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_POSITION_TYPE)
    private String positionType;

    /**
     * 主岗位
     */
    @ExcelProperty(value = "主岗位")
    private String position;

    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名")
    private String name;

    /**
     * 性别
     */
    @ExcelProperty(value = "性别", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_USER_SEX)
    private String gender;

    /**
     * 身份证号码
     */
    @NotBlank(message = "身份证号码不能为空", groups = {AddGroup.class, EditGroup.class})
    @ExcelProperty(value = "身份证号码")
    private String idCardNumber;

    /**
     //     * OSS_ID
     //     */
//    @ExcelIgnore
//    private Long ossId;

//    /**
//     * 照片
//     */
//    @ExcelProperty(value = "照片", converter = ExcelUrlImageConverter.class)
//    private String photo;

    /**
     * 出生日期
     */
    @ExcelProperty(value = "出生日期")
    private LocalDate birthDate;

    /**
     * 年龄
     */
    @ExcelProperty(value = "年龄")
    private Integer age;

//    /**
//     * 年龄段
//     */
//    @ExcelProperty(value = "年龄段", converter = ExcelDictConvert.class)
//    @ExcelDictFormat(dictType = HrConstant.HR_AGE_GROUP)
//    private String ageGroup;

    /**
     * 籍贯
     */
    @ExcelProperty(value = "籍贯")
    private String nativePlace;

    /**
     * 民族
     */
    @ExcelProperty(value = "民族")
    private String ethnicity;

    /**
     * 婚姻状况
     */
    @ExcelProperty(value = "婚姻状况", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_MARITAL_STATUS)
    private String maritalStatus;

    /**
     * 政治面貌
     */
    @ExcelProperty(value = "政治面貌", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_POLITICAL_STATUS)
    private String politicalStatus;

    /**
     * 手机号码
     */
    @ExcelProperty(value = "手机号码")
    private String phoneNumber;

    /**
     * 紧急联系人
     */
    @ExcelProperty(value = "紧急联系人")
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    @ExcelProperty(value = "紧急联系人电话")
    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    @ExcelProperty(value = "家庭地址")
    private String homeAddress;

    /**
     * 入职时间
     */
    @ExcelProperty(value = "入职时间")
    private LocalDate entryDate;

    /**
     * 全日制学历
     */
    @ExcelProperty(value = "全日制学历")
    private String fulltimeEducation;

    /**
     * 全日制毕业院校
     */
    @ExcelProperty(value = "全日制毕业院校")
    private String fulltimeSchool;

    /**
     * 全日制专业
     */
    @ExcelProperty(value = "全日制专业")
    private String fulltimeMajor;

    /**
     * 全日制毕业日期
     */
    @ExcelProperty(value = "全日制毕业日期")
    private LocalDate fulltimeGraduationDate;

    /**
     * 全日制学位
     */
    @ExcelProperty(value = "全日制学位")
    private String fulltimeDegree;

    /**
     * 用工形式
     */
    @ExcelProperty(value = "用工形式", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_EMPLOYMENT_FORM)
    private String employmentForm;

//    /**
//     * 是否兼职
//     */
//    @ExcelProperty(value = "是否兼职")
//    private String partTimeFlag;

    /**
     * 签订兼职协议
     */
    @ExcelProperty(value = "签订兼职协议", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.SYS_YES_NO)
    private String partTimeAgreement;

    /**
     * 协议主体
     */
    @ExcelProperty(value = "协议主体")
    private String agreementEntity;

    /**
     * 协议期限
     */
    @ExcelProperty(value = "协议期限")
    private String agreementPeriod;

    /**
     * 协议开始时间
     */
    @ExcelProperty(value = "协议开始时间")
    private LocalDate agreementStartDate;

    /**
     * 协议截止时间
     */
    @ExcelProperty(value = "协议截止时间")
    private LocalDate agreementEndDate;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remarks;

    /**
     * 银行卡号
     */
    @ExcelProperty(value = "银行卡号")
    private String bankCardNumber;

    /**
     * 开户行
     */
    @ExcelProperty(value = "开户行")
    private String bankName;

    /**
     * 公司内是否有亲属关系
     */
    @ExcelProperty(value = "公司内是否有亲属关系", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.SYS_YES_NO)
    private String hasRelativeInCompany;

    /**
     * 亲属姓名
     */
    @ExcelProperty(value = "亲属姓名")
    private String relativeName;

    /**
     * 介绍人
     */
    @ExcelProperty(value = "介绍人")
    private String introducer;

    /**
     * 介绍人关系
     */
    @ExcelProperty(value = "介绍人关系")
    private String introducerRelation;

    /**
     * 工资发放地
     */
    @ExcelProperty(value = "工资发放地")
    private String salaryLocation;

    /**
     * 成本费用所属
     */
    @ExcelProperty(value = "成本费用所属")
    private String costOfDept;

    public void setPlate(String plate) {
        this.plate = plate == null ? null : plate.trim();
    }

    public void setFirstLevelDepartment(String firstLevelDepartment) {
        this.firstLevelDepartment = firstLevelDepartment == null ? null : firstLevelDepartment.trim();
    }

    public void setSecondLevelDepartment(String secondLevelDepartment) {
        this.secondLevelDepartment = secondLevelDepartment == null ? null : secondLevelDepartment.trim();
    }

    public void setThirdLevelDepartment(String thirdLevelDepartment) {
        this.thirdLevelDepartment = thirdLevelDepartment == null ? null : thirdLevelDepartment.trim();
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType == null ? null : positionType.trim();
    }

    public void setPosition(String position) {
        this.position = position == null ? null : position.trim();
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public void setGender(String gender) {
        this.gender = gender == null ? null : gender.trim();
    }

    public void setIdCardNumber(String idCardNumber) {
        this.idCardNumber = idCardNumber == null ? null : idCardNumber.trim();
    }

    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public void setNativePlace(String nativePlace) {
        this.nativePlace = nativePlace == null ? null : nativePlace.trim();
    }

    public void setEthnicity(String ethnicity) {
        this.ethnicity = ethnicity == null ? null : ethnicity.trim();
    }

    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus == null ? null : maritalStatus.trim();
    }

    public void setPoliticalStatus(String politicalStatus) {
        this.politicalStatus = politicalStatus == null ? null : politicalStatus.trim();
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber == null ? null : phoneNumber.trim();
    }

    public void setEmergencyContact(String emergencyContact) {
        this.emergencyContact = emergencyContact == null ? null : emergencyContact.trim();
    }

    public void setEmergencyContactPhone(String emergencyContactPhone) {
        this.emergencyContactPhone = emergencyContactPhone == null ? null : emergencyContactPhone.trim();
    }

    public void setHomeAddress(String homeAddress) {
        this.homeAddress = homeAddress == null ? null : homeAddress.trim();
    }

    public void setEntryDate(LocalDate entryDate) {
        this.entryDate = entryDate;
    }

    public void setFulltimeEducation(String fulltimeEducation) {
        this.fulltimeEducation = fulltimeEducation == null ? null : fulltimeEducation.trim();
    }

    public void setFulltimeSchool(String fulltimeSchool) {
        this.fulltimeSchool = fulltimeSchool == null ? null : fulltimeSchool.trim();
    }

    public void setFulltimeMajor(String fulltimeMajor) {
        this.fulltimeMajor = fulltimeMajor == null ? null : fulltimeMajor.trim();
    }

    public void setFulltimeGraduationDate(LocalDate fulltimeGraduationDate) {
        this.fulltimeGraduationDate = fulltimeGraduationDate;
    }

    public void setFulltimeDegree(String fulltimeDegree) {
        this.fulltimeDegree = fulltimeDegree == null ? null : fulltimeDegree.trim();
    }

    public void setEmploymentForm(String employmentForm) {
        this.employmentForm = employmentForm == null ? null : employmentForm.trim();
    }

    public void setPartTimeAgreement(String partTimeAgreement) {
        this.partTimeAgreement = partTimeAgreement == null ? null : partTimeAgreement.trim();
    }

    public void setAgreementEntity(String agreementEntity) {
        this.agreementEntity = agreementEntity == null ? null : agreementEntity.trim();
    }

    public void setAgreementPeriod(String agreementPeriod) {
        this.agreementPeriod = agreementPeriod == null ? null : agreementPeriod.trim();
    }

    public void setAgreementStartDate(LocalDate agreementStartDate) {
        this.agreementStartDate = agreementStartDate;
    }

    public void setAgreementEndDate(LocalDate agreementEndDate) {
        this.agreementEndDate = agreementEndDate;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }

    public void setBankCardNumber(String bankCardNumber) {
        this.bankCardNumber = bankCardNumber == null ? null : bankCardNumber.trim();
    }

    public void setBankName(String bankName) {
        this.bankName = bankName == null ? null : bankName.trim();
    }

    public void setHasRelativeInCompany(String hasRelativeInCompany) {
        this.hasRelativeInCompany = hasRelativeInCompany == null ? null : hasRelativeInCompany.trim();
    }

    public void setRelativeName(String relativeName) {
        this.relativeName = relativeName == null ? null : relativeName.trim();
    }

    public void setIntroducer(String introducer) {
        this.introducer = introducer == null ? null : introducer.trim();
    }

    public void setIntroducerRelation(String introducerRelation) {
        this.introducerRelation = introducerRelation == null ? null : introducerRelation.trim();
    }

    public void setSalaryLocation(String salaryLocation) {
        this.salaryLocation = salaryLocation == null ? null : salaryLocation.trim();
    }

    public void setCostOfDept(String costOfDept) {
        this.costOfDept = costOfDept == null ? null : costOfDept.trim();
    }
}
