package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnore;
import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.constant.HrConstant;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.core.trans.anno.Trans;
import org.dromara.core.trans.constant.TransType;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.annotion.ExcelImageCellFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;
import top.binfast.common.excel.converters.ExcelUrlImageConverter;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 简历视图对象
 * @author 刘斌
 * @date 2025/12/2 16:56
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = EmployeeInfoVo.class, convertGenerate = false)
public class EmployeeInfoResumeVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 板块
     */
    @ExcelProperty(value = "板块")
    private String plate;

    /**
     * 一级部门
     */
    @ExcelProperty(value = "一级部门")
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @ExcelProperty(value = "二级部门")
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    @ExcelProperty(value = "三级部门")
    private String thirdLevelDepartment;

    /**
     * 工号
     */
    @ExcelProperty(value = "工号")
    private String employeeNo;

    /**
     * 职级
     */
    @ExcelProperty(value = "职级")
//    @ExcelDictFormat(dictType = "HR_JOB_LEVEL")
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_JOB_LEVEL)
    private Integer jobLevel;

    /**
     * 岗位类型
     */
    @ExcelProperty(value = "岗位类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_POSITION_TYPE)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_POSITION_TYPE)
    private String positionType;

    /**
     * 序列
     */
    @ExcelProperty(value = "序列", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_SEQUENCE)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_SEQUENCE)
    private String sequence;

    /**
     * 主岗位
     */
    @ExcelProperty(value = "主岗位")
    private String position;

    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名")
    private String name;

    /**
     * 性别
     */
    @ExcelProperty(value = "性别", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_USER_SEX)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_USER_SEX)
    private String gender;

    /**
     * 身份证号码
     */
    @ExcelProperty(value = "身份证号码")
    private String idCardNumber;

    /**
     * 头像OSS_ID
     */
    @ExcelIgnore
    private Long ossId;

    /**
     * 照片
     */
    @ExcelImageCellFormat(relativeLastRowIndex = 3)
    @ExcelProperty(value = "照片", converter = ExcelUrlImageConverter.class)
    private String photo;

    /**
     * 出生日期
     */
    @ExcelProperty(value = "出生日期")
    private LocalDate birthDate;

    /**
     * 年龄
     */
    @ExcelProperty(value = "年龄")
    private Integer age;

    /**
     * 民族
     */
    @ExcelProperty(value = "民族")
    private String ethnicity;

    /**
     * 婚姻状况
     */
    @ExcelProperty(value = "婚姻状况", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_MARITAL_STATUS)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_MARITAL_STATUS)
    private String maritalStatus;

    /**
     * 政治面貌
     */
    @ExcelProperty(value = "政治面貌", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_POLITICAL_STATUS)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_POLITICAL_STATUS)
    private String politicalStatus;

    /**
     * 手机号码
     */
    @ExcelProperty(value = "手机号码")
    private String phoneNumber;

    /**
     * 是否兼岗
     */
    @ExcelProperty(value = "是否兼岗")
    private String concurrentFlag;

    /**
     * 兼岗板块
     */
    @ExcelProperty(value = "兼岗板块")
    private String concurrentPlate;

    /**
     * 兼岗一级部门
     */
    @ExcelProperty(value = "兼岗一级部门")
    private String concurrentFirstDept;

    /**
     * 兼岗二级部门
     */
    @ExcelProperty(value = "兼岗二级部门")
    private String concurrentSecondDept;

    /**
     * 兼岗三级部门
     */
    @ExcelProperty(value = "兼岗三级部门")
    private String concurrentThirdDept;

    /**
     * 兼岗岗位
     */
    @ExcelProperty(value = "兼岗岗位")
    private String concurrentPosition;

    /**
     * 兼岗岗位类型
     */
    @ExcelProperty(value = "兼岗岗位类型")
    private String concurrentPositionType;

    /**
     * 入职时间
     */
    @ExcelProperty(value = "入职时间")
    private LocalDate entryDate;

    /**
     * 工龄
     */
    @ExcelProperty(value = "工龄")
    private String yearsOfService;

    /**
     * 全日制学历
     */
    @ExcelProperty(value = "全日制学历")
    private String fulltimeEducation;

    /**
     * 全日制毕业院校
     */
    @ExcelProperty(value = "全日制毕业院校")
    private String fulltimeSchool;

    /**
     * 全日制专业
     */
    @ExcelProperty(value = "全日制专业")
    private String fulltimeMajor;

    /**
     * 全日制毕业日期
     */
    @ExcelProperty(value = "全日制毕业日期")
    private LocalDate fulltimeGraduationDate;

    /**
     * 非全日制学历
     */
    @ExcelProperty(value = "非全日制学历")
    private String nonFulltimeEducation;

    /**
     * 非全日制毕业院校
     */
    @ExcelProperty(value = "非全日制毕业院校")
    private String nonFulltimeSchool;

    /**
     * 非全日制专业
     */
    @ExcelProperty(value = "非全日制专业")
    private String nonFulltimeMajor;

    /**
     * 非全日制毕业日期
     */
    @ExcelProperty(value = "非全日制毕业日期")
    private LocalDate nonFulltimeGraduationDate;

    /**
     * 外部个人履历
     */
    @ExcelProperty(value = "外部个人履历")
    private String externalResume;

    /**
     * 内部个人履历
     */
    @ExcelProperty(value = "内部个人履历")
    private String internalResume;

    /**
     * 合同形式
     */
    @ExcelProperty(value = "合同形式", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_CONTRACT_FORM)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_CONTRACT_FORM)
    private String contractForm;

    /**
     * 是否缴纳社保
     */
    @ExcelProperty(value = "是否缴纳社保", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.SYS_YES_NO)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.SYS_YES_NO)
    private String hasSocialSecurityPaid;

    /**
     * 是否缴纳公积金
     */
    @ExcelProperty(value = "是否缴纳公积金", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.SYS_YES_NO)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.SYS_YES_NO)
    private String hasProvidentFundPaid;

    /**
     * 转正时间
     */
    @ExcelProperty(value = "转正时间")
    private LocalDate regularizationDate;

    /**
     * 奖励情况
     */
    @ExcelProperty(value = "奖励情况")
    private String rewardStatus;

    /**
     * 处罚情况
     */
    @ExcelProperty(value = "处罚情况")
    private String punishmentStatus;

    /**
     * 家庭主要成员
     */
    @ExcelProperty(value = "家庭主要成员")
    private List<EmployeeFamilyMembersVo> familyMembers;

    /**
     * 培训情况
     */
    @ExcelProperty(value = "培训情况")
    private List<EmployeeTrainingVo> trainings;

    /**
     * 招揽岗位
     */
    @ExcelProperty(value = "招揽岗位")
    private String jobPosition;

    /**
     * 标杆企业
     */
    @ExcelProperty(value = "标杆企业")
    private String benchmarkEnterprise;

    /**
     * 面试时间
     */
    @ExcelProperty(value = "面试时间")
    private LocalDate interviewDate;

    /**
     * 面试情况
     */
    @ExcelProperty(value = "面试情况")
    private String interviewSituation;

    /**
     * 面试结果
     */
    @ExcelProperty(value = "面试结果", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_INTERVIEW_RESULT)
    private String interviewResult;

}
