package com.anplus.hr.domain.params;

import com.anplus.hr.domain.InterviewProfile;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import jakarta.validation.constraints.*;
import java.time.LocalDate;

/**
 * 面试档案业务对象 interview_profile
 *
 * @author LiuBin
 * @date 2025-12-08
 */
@Data
@AutoMapper(target = InterviewProfile.class, reverseConvertGenerate = false)
public class InterviewProfileParam {

    /**
     * 主键
     */
    @NotNull(message = "主键不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 员工信息ID
     */
//    @NotNull(message = "员工信息ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long employeeId;

    /**
     * 招揽岗位
     */
    @NotBlank(message = "招揽岗位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String jobPosition;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 性别
     */
    @NotBlank(message = "性别不能为空", groups = { AddGroup.class, EditGroup.class })
    private String gender;

    /**
     * 身份证号
     */
    @NotBlank(message = "身份证号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String idCardNumber;

    /**
     * 学历
     */
    @NotBlank(message = "学历不能为空", groups = { AddGroup.class, EditGroup.class })
    private String education;

    /**
     * 院校
     */
    @NotBlank(message = "院校不能为空", groups = { AddGroup.class, EditGroup.class })
    private String school;

    /**
     * 专业
     */
    @NotBlank(message = "专业不能为空", groups = { AddGroup.class, EditGroup.class })
    private String major;

    /**
     * 联系方式
     */
    @NotBlank(message = "联系方式不能为空", groups = { AddGroup.class, EditGroup.class })
    private String phoneNumber;

    /**
     * 标杆企业
     */
//    @NotBlank(message = "标杆企业不能为空", groups = { AddGroup.class, EditGroup.class })
    private String benchmarkEnterprise;

    /**
     * 面试时间
     */
    @NotNull(message = "面试时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate interviewDate;

    /**
     * 面试情况
     */
    @NotBlank(message = "面试情况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String interviewSituation;

    /**
     * 面试结果
     */
    @NotBlank(message = "面试结果不能为空", groups = { AddGroup.class, EditGroup.class })
    private String interviewResult;

    /**
     * 备注
     */
//    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;


}
