package com.anplus.hr.service;

import com.alibaba.cola.dto.PageResponse;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.EmployeeRegularReminderListParam;
import com.anplus.hr.domain.params.EmployeeRegularReminderParam;
import com.anplus.hr.domain.vo.EmployeeRegularReminderVo;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * 转正提醒Service接口
 *
 * @author LiuBin
 * @date 2025-11-20
 */
public interface EmployeeRegularReminderServ extends IService<EmployeeInfo> {


    /**
     * 分页查询转正提醒列表
     *
     * @param param 查询条件
     * @return 转正提醒分页列表
     */
    PageResponse<EmployeeRegularReminderVo> queryPageList(EmployeeRegularReminderListParam param);

    /**
     * 查询符合条件的转正提醒列表
     *
     * @param param 查询条件
     * @return 转正提醒列表
     */
    List<EmployeeRegularReminderVo> queryList(EmployeeRegularReminderListParam param);

    /**
     * 查询转正提醒
     *
     * @param id 主键
     * @return 转正提醒
     */
    EmployeeRegularReminderVo queryById(Long id);

    /**
     * 新增转正提醒
     *
     * @param param 转正提醒
     * @return 是否新增成功
     */
    Boolean insertByParam(EmployeeRegularReminderParam param);

    /**
     * 修改转正提醒
     *
     * @param param 转正提醒
     * @return 是否修改成功
     */
    Boolean updateByParam(EmployeeRegularReminderParam param);

    /**
     * 校验并批量删除转正提醒信息
     *
     * @param ids 待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

}
