package com.anplus.hr.domain.vo;

import java.time.LocalDate;

import com.anplus.hr.constant.HrConstant;
import com.anplus.hr.domain.InterviewProfile;
import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import cn.idev.excel.annotation.ExcelIgnore;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;



/**
 * 面试档案视图对象 interview_profile
 *
 * @author LiuBin
 * @date 2025-12-08
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = InterviewProfile.class)
public class InterviewProfileVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 员工信息ID
     */
    @ExcelProperty(value = "员工信息ID")
    private Long employeeId;

    /**
     * 招揽岗位
     */
    @ExcelProperty(value = "招揽岗位")
    private String jobPosition;

    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名")
    private String name;

    /**
     * 性别
     */
    @ExcelProperty(value = "性别")
    private String gender;

    /**
     * 身份证号
     */
    @ExcelProperty(value = "身份证号")
    private String idCardNumber;

    /**
     * 学历
     */
    @ExcelProperty(value = "学历")
    private String education;

    /**
     * 院校
     */
    @ExcelProperty(value = "院校")
    private String school;

    /**
     * 专业
     */
    @ExcelProperty(value = "专业")
    private String major;

    /**
     * 联系方式
     */
    @ExcelProperty(value = "联系方式")
    private String phoneNumber;

    /**
     * 标杆企业
     */
    @ExcelProperty(value = "标杆企业")
    private String benchmarkEnterprise;

    /**
     * 面试时间
     */
    @ExcelProperty(value = "面试时间")
    private LocalDate interviewDate;

    /**
     * 面试情况
     */
    @ExcelProperty(value = "面试情况")
    private String interviewSituation;

    /**
     * 面试结果
     */
    @ExcelProperty(value = "面试结果", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_INTERVIEW_RESULT)
    private String interviewResult;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


}
