package com.anplus.hr.domain.vo;

import java.time.LocalDate;
import com.anplus.hr.domain.EmployeeLaborCost;
import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import cn.idev.excel.annotation.ExcelIgnore;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;



/**
 * 人工成本档案视图对象 employee_labor_cost
 *
 * @author LiuBin
 * @date 2025-12-09
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = EmployeeLaborCost.class)
public class EmployeeLaborCostVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 记录时间
     */
    @ExcelProperty(value = "记录时间")
    private LocalDate recordDate;

    /**
     * 文件ID
     */
    @ExcelProperty(value = "文件ID")
    private Long ossId;

    /**
     * 文件Key
     */
    @ExcelProperty(value = "文件Key")
    private String fileKey;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


}
