package com.anplus.hr.domain.params;

import com.anplus.hr.domain.EmployeeInfo;
import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;

import java.time.LocalDate;

/**
 * 员工合同续签提醒业务对象 employee_contract_expiration_reminder
 *
 * @author LiuBin
 * @date 2025-11-20
 */
@Data
@AutoMapper(target = EmployeeInfo.class, reverseConvertGenerate = false)
public class ContractExpirationReminderParam {

    /**
     * 主键
     */
    @NotNull(message = "主键不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 板块
     */
    @NotBlank(message = "板块不能为空", groups = { AddGroup.class, EditGroup.class })
    private String plate;

    /**
     * 一级部门
     */
    @NotBlank(message = "一级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @NotBlank(message = "二级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    @NotBlank(message = "三级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    @NotNull(message = "部门ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long deptId;

    /**
     * 主岗位
     */
    @NotBlank(message = "主岗位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String position;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 手机号码
     */
    @NotBlank(message = "手机号码不能为空", groups = { AddGroup.class, EditGroup.class })
    private String phoneNumber;

    /**
     * 劳动合同开始时间
     */
    @NotNull(message = "劳动合同开始时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
    @NotNull(message = "劳动合同截止时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate contractEndDate;

    /**
     * 合同形式
     */
    @NotBlank(message = "合同形式不能为空", groups = { AddGroup.class, EditGroup.class })
    private String contractForm;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remarks;


}
