package com.anplus.hr.domain;

import top.binfast.common.mybatis.bean.model.TenantModel;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.time.LocalDate;

import java.io.Serial;

/**
 * 面试档案对象 interview_profile
 *
 * @author LiuBin
 * @date 2025-12-08
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@TableName("interview_profile")
public class InterviewProfile extends TenantModel {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 员工信息ID
     */
    private Long employeeId;

    /**
     * 招揽岗位
     */
    private String jobPosition;

    /**
     * 姓名
     */
    private String name;

    /**
     * 性别
     */
    private String gender;

    /**
     * 身份证号
     */
    private String idCardNumber;

    /**
     * 学历
     */
    private String education;

    /**
     * 院校
     */
    private String school;

    /**
     * 专业
     */
    private String major;

    /**
     * 联系方式
     */
    private String phoneNumber;

    /**
     * 标杆企业
     */
    private String benchmarkEnterprise;

    /**
     * 面试时间
     */
    private LocalDate interviewDate;

    /**
     * 面试情况
     */
    private String interviewSituation;

    /**
     * 面试结果
     */
    private String interviewResult;

    /**
     * 备注
     */
    private String remark;


}
