package com.anplus.hr.domain;

import top.binfast.common.mybatis.bean.model.TenantModel;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;

import java.io.Serial;

/**
 * 员工家庭主要成员对象 employee_family_members
 *
 * @author LiuBin
 * @date 2025-12-04
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@TableName("employee_family_members")
public class EmployeeFamilyMembers extends TenantModel {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 员工信息ID
     */
    private Long employeeId;

    /**
     * 关系
     */
    private String relation;

    /**
     * 姓名
     */
    private String name;

    /**
     * 出生年月
     */
    private String birthDate;

    /**
     * 工作单位及职务
     */
    private String companyAndJob;

    /**
     * 联系方式
     */
    private String contact;

    /**
     * 是否为紧急联系人
     */
    private String emergencyFlag;


}
