package com.anplus.hr.service;

import top.binfast.app.biz.sysapi.bean.params.sysDept.SysDeptParam;
import top.binfast.app.biz.sysapi.bean.vo.sysDept.SysDeptDTO;

import java.util.List;
import java.util.Map;

/**
 * @author 刘斌
 * @date 2025/11/6 11:27
 */
public interface EmployeeSysDeptServ {

    /**
     * 根据部门id查询部门名称以及父级部门名称
     *
     * @param deptId 部门id
     */
    List<String> selectDeptNameAncestorsById(Long deptId);

    /**
     * 查询部门树结构
     */
    List<SysDeptDTO> selectDeptTreeForEmployee(SysDeptParam param);

    /**
     * 查询部门名称和叶子部门ID，部门名拼接成串作为key
     */
    Map<String, Long> selectJoinDeptNames();

    /**
     * 构建部门查询条件
     *
     * @param belongDeptId 部门id
     */
    List<Long> buildQueryWrapper(Long belongDeptId);

}
