package com.anplus.hr.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import com.alibaba.cola.dto.PageResponse;
import com.anplus.hr.domain.params.EmployeeRegularReminderListParam;
import com.anplus.hr.domain.vo.EmployeeRegularReminderVo;
import com.anplus.hr.service.EmployeeRegularReminderServ;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import top.binfast.common.core.constant.BusinessType;
import top.binfast.common.excel.annotion.ExcelExport;
import top.binfast.common.log.annotation.PinSysLog;

import java.util.List;

/**
 * 转正提醒
 *
 * @author LiuBin
 * @date 2025-11-20
 */
@Validated
@RestController
@RequestMapping("/employee/regularReminder")
public class EmployeeRegularReminderCtrl {

    @Resource
    private EmployeeRegularReminderServ employeeRegularReminderServ;

    /**
     * 查询转正提醒列表
     */
    @SaCheckPermission("employee:regularReminder:list")
    @GetMapping("/page")
    public PageResponse<EmployeeRegularReminderVo> pageList(EmployeeRegularReminderListParam param) {
        return employeeRegularReminderServ.queryPageList(param);
    }

    /**
     * 导出转正提醒列表
     */
    @ExcelExport
    @SaCheckPermission("employee:regularReminder:export")
    @PinSysLog(value = "转正提醒", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public List<EmployeeRegularReminderVo> export(EmployeeRegularReminderListParam param) {
        return employeeRegularReminderServ.queryList(param);
    }

//    /**
//     * 获取转正提醒详细信息
//     *
//     * @param id 主键
//     */
//    @SaCheckPermission("employee:regularReminder:query")
//    @GetMapping("/{id}")
//    public SingleResponse<EmployeeRegularReminderVo> getDetail(@PathVariable @Min(1)
//                                                    Long id) {
//        return SingleResponse.of(employeeRegularReminderServ.queryById(id));
//    }

//    /**
//     * 新增转正提醒
//     */
//    @SaCheckPermission("employee:regularReminder:add")
//    @PinSysLog(value = "转正提醒", businessType = BusinessType.INSERT)
//    @PostMapping()
//    public Response add(@Validated(AddGroup.class) @RequestBody EmployeeRegularReminderParam param) {
//        return ResponseUtils.ofResult(employeeRegularReminderServ.insertByParam(param));
//    }
//
//    /**
//     * 修改转正提醒
//     */
//    @SaCheckPermission("employee:regularReminder:edit")
//    @PinSysLog(value = "转正提醒", businessType = BusinessType.UPDATE)
//    @PutMapping()
//    public Response edit(@Validated(EditGroup.class) @RequestBody EmployeeRegularReminderParam param) {
//        return ResponseUtils.ofResult(employeeRegularReminderServ.updateByParam(param));
//    }
//
//    /**
//     * 删除转正提醒
//     *
//     * @param ids 主键串
//     */
//    @SaCheckPermission("employee:regularReminder:remove")
//    @PinSysLog(value = "转正提醒", businessType = BusinessType.DELETE)
//    @DeleteMapping("/{ids}")
//    public Response remove(@NotEmpty(message = "主键不能为空")
//                           @PathVariable Long[] ids) {
//        return ResponseUtils.ofResult(employeeRegularReminderServ.delByIds(List.of(ids)));
//    }
}