package com.anplus.hr.config;

import com.anplus.hr.constant.HrCacheConstants;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import top.binfast.app.biz.sysapi.bean.params.sysDept.SysDeptParam;
import top.binfast.common.redis.util.CacheUtils;

/**
 * @author 刘斌
 * @date 2025/11/12 10:19
 */
@Aspect
@Component
@Slf4j
public class RefreshDeptCacheAspect {

    /**
     * 定义切入点：Controller包下的方法
     */
    @Pointcut("execution(* top.binfast.app.admin.controller.SysDeptCtrl.add(..)) ||" +
            " execution(* top.binfast.app.admin.controller.SysDeptCtrl.edit(..)) ||" +
            " execution(* top.binfast.app.admin.controller.SysDeptCtrl.deleteOne(..))")
    public void deptChangePointcut() {}

    /**
     * 方法一：基于注解的监听
     */
    @AfterReturning(pointcut = "deptChangePointcut()", returning = "result")
    public void afterOperation(JoinPoint joinPoint, Object result) {
        try {
            // 获取方法参数
            Object[] args = joinPoint.getArgs();
            if (args == null || args.length == 0) {
                return;
            }
            Long deptId = null;
            if (args[0] instanceof SysDeptParam param) {
                deptId = param.getId();
            } else if (args[0] instanceof Long) {
                deptId = (Long) args[0];
            }
            if (deptId != null) {
                // 清除部门缓存
                CacheUtils.evict(HrCacheConstants.DEPT_AND_PARENT_NAME, deptId + "");
            }
            CacheUtils.clear(HrCacheConstants.DEPT_AND_CHILD_TREE);

        } catch (Exception e) {
            log.error("清除部门缓存异常", e);
        }
    }
}
