package com.anplus.hr.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cola.dto.PageResponse;
import com.anplus.hr.domain.StaffingPlanRecords;
import com.anplus.hr.domain.params.StaffingPlanRecordsListParam;
import com.anplus.hr.domain.params.StaffingPlanRecordsParam;
import com.anplus.hr.domain.vo.StaffingPlanRecordsVo;
import com.anplus.hr.mapper.StaffingPlanRecordsMapper;
import com.anplus.hr.service.StaffingPlanRecordsServ;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import top.binfast.common.core.util.MapstructUtils;
import top.binfast.common.mybatis.util.QueryUtil;

import java.util.List;

/**
 * 编制规划记录Service业务层处理
 *
 * @author LiuBin
 * @date 2025-12-14
 */
@RequiredArgsConstructor
@Service
public class StaffingPlanRecordsServImpl extends ServiceImpl<StaffingPlanRecordsMapper, StaffingPlanRecords> implements StaffingPlanRecordsServ {

    private final StaffingPlanRecordsMapper staffingPlanRecordsMapper;

    /**
     * 分页查询编制规划记录列表
     *
     * @param param 查询条件
     * @return 编制规划记录分页列表
     */
    @Override
    public PageResponse<StaffingPlanRecordsVo> queryPageList(StaffingPlanRecordsListParam param) {
        Page<StaffingPlanRecords> page = QueryUtil.getPage(param);
        LambdaQueryWrapper<StaffingPlanRecords> lambdaQuery = this.buildQueryWrapper(param);
        staffingPlanRecordsMapper.selectPage(page, lambdaQuery);
        return QueryUtil.getPageResponse(page, MapstructUtils.convert(page.getRecords(), StaffingPlanRecordsVo.class));
    }


    /**
     * 查询符合条件的编制规划记录列表
     *
     * @param param 查询条件
     * @return 编制规划记录列表
     */
    @Override
    public List<StaffingPlanRecordsVo> queryList(StaffingPlanRecordsListParam param) {
        LambdaQueryWrapper<StaffingPlanRecords> lambdaQuery = this.buildQueryWrapper(param);
        return MapstructUtils.convert(staffingPlanRecordsMapper.selectList(lambdaQuery), StaffingPlanRecordsVo.class);
    }

    private LambdaQueryWrapper<StaffingPlanRecords> buildQueryWrapper(StaffingPlanRecordsListParam param) {
        LambdaQueryWrapper<StaffingPlanRecords> lambdaQuery = Wrappers.<StaffingPlanRecords>lambdaQuery();
        lambdaQuery.orderByDesc(StaffingPlanRecords::getId);
        lambdaQuery.eq(StrUtil.isNotBlank(param.getRecordDate()), StaffingPlanRecords::getRecordDate, param.getRecordDate());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getLastYearTitle()), StaffingPlanRecords::getLastYearTitle, param.getLastYearTitle());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getCurrentYearTitle()), StaffingPlanRecords::getCurrentYearTitle, param.getCurrentYearTitle());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getNextYearTitle()), StaffingPlanRecords::getNextYearTitle, param.getNextYearTitle());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getInitFlag()), StaffingPlanRecords::getInitFlag, param.getInitFlag());
        return lambdaQuery;
    }

    /**
     * 查询编制规划记录
     *
     * @param id 主键
     * @return 编制规划记录
     */
    @Override
    public StaffingPlanRecordsVo queryById(Long id) {
        StaffingPlanRecords staffingPlanRecords = staffingPlanRecordsMapper.selectById(id);
        return MapstructUtils.convert(staffingPlanRecords, StaffingPlanRecordsVo.class);
    }

    /**
     * 新增编制规划记录
     *
     * @param param 编制规划记录
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByParam(StaffingPlanRecordsParam param) {
        StaffingPlanRecords staffingPlanRecords = MapstructUtils.convert(param, StaffingPlanRecords.class);
        String recordDate = staffingPlanRecords.getRecordDate();
        Integer recordYear = Convert.toInt(recordDate);
        staffingPlanRecords.setLastYearTitle(StrUtil.subSuf((recordYear - 1) + "年编制", 2));
        staffingPlanRecords.setCurrentYearTitle(StrUtil.subSuf(recordDate + "年编制", 2));
        staffingPlanRecords.setNextYearTitle(StrUtil.subSuf((recordYear + 1) + "年编制", 2));
        return this.save(staffingPlanRecords);
    }

    /**
     * 修改编制规划记录
     *
     * @param param 编制规划记录
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByParam(StaffingPlanRecordsParam param) {
        StaffingPlanRecords staffingPlanRecords = MapstructUtils.convert(param, StaffingPlanRecords.class);
        return this.updateById(staffingPlanRecords);
    }

    /**
     * 校验记录日期是否唯一
     *
     * @param param 待校验的参数
     * @return 是否唯一
     */
    @Override
    public boolean checkRecordDateUnique(StaffingPlanRecordsParam param) {
        boolean exist = staffingPlanRecordsMapper.exists(new LambdaQueryWrapper<StaffingPlanRecords>()
                .eq(StaffingPlanRecords::getRecordDate, param.getRecordDate())
                .ne(ObjectUtil.isNotNull(param.getId()), StaffingPlanRecords::getId, param.getId()));
        return !exist;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(StaffingPlanRecords entity) {
        // 做一些数据校验,如唯一约束
    }

    /**
     * 校验并批量删除编制规划记录信息
     *
     * @param ids 待删除的主键集合
     * @return 是否删除成功
     */
    @Override
//    @Transactional(rollbackFor = {Exception.class})
    public Boolean delByIds(List<Long> ids) {
        //做一些业务上的校验,判断是否需要校验
        return this.removeByIds(ids);
    }
}
