package com.anplus.hr.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cola.dto.PageResponse;
import com.alibaba.cola.dto.Response;
import com.anplus.hr.constant.HrEmployeeConstants;
import com.anplus.hr.domain.StaffingPlanRecords;
import com.anplus.hr.domain.vo.*;
import com.anplus.hr.mapper.StaffingPlanRecordsMapper;
import com.anplus.hr.service.EmployeeSysDeptServ;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import top.binfast.common.core.enums.ResultCode;
import top.binfast.common.core.util.MapstructUtils;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.excel.core.ExcelContextHolder;
import top.binfast.common.mybatis.util.QueryUtil;
import com.anplus.hr.domain.StaffingPlanData;
import com.anplus.hr.domain.params.StaffingPlanDataListParam;
import com.anplus.hr.domain.params.StaffingPlanDataParam;
import com.anplus.hr.mapper.StaffingPlanDataMapper;
import com.anplus.hr.service.StaffingPlanDataServ;

import java.util.*;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

/**
 * 编制规划记录明细Service业务层处理
 *
 * @author LiuBin
 * @date 2025-12-14
 */
@RequiredArgsConstructor
@Service
public class StaffingPlanDataServImpl extends ServiceImpl<StaffingPlanDataMapper, StaffingPlanData> implements StaffingPlanDataServ {

    private final StaffingPlanDataMapper staffingPlanDataMapper;
    private final StaffingPlanRecordsMapper staffingPlanRecordsMapper;
    private final EmployeeSysDeptServ employeeSysDeptServ;

    /**
     * 分页查询编制规划记录明细列表
     *
     * @param param 查询条件
     * @return 编制规划记录明细分页列表
     */
    @Override
    public PageResponse<StaffingPlanDataVo> queryPageList(StaffingPlanDataListParam param) {
        Page<StaffingPlanData> page = QueryUtil.getPage(param);
        LambdaQueryWrapper<StaffingPlanData> lambdaQuery = this.buildQueryWrapper(param);
        staffingPlanDataMapper.selectPage(page, lambdaQuery);
        return QueryUtil.getPageResponse(page, MapstructUtils.convert(page.getRecords(), StaffingPlanDataVo.class));
    }


    /**
     * 查询符合条件的编制规划记录明细列表
     *
     * @param param 查询条件
     * @return 编制规划记录明细列表
     */
    @Override
    public List<StaffingPlanDataVo> queryList(StaffingPlanDataListParam param) {
        LambdaQueryWrapper<StaffingPlanData> lambdaQuery = this.buildQueryWrapper(param);
        return MapstructUtils.convert(staffingPlanDataMapper.selectList(lambdaQuery), StaffingPlanDataVo.class);
    }

    private LambdaQueryWrapper<StaffingPlanData> buildQueryWrapper(StaffingPlanDataListParam param) {
        LambdaQueryWrapper<StaffingPlanData> lambdaQuery = Wrappers.<StaffingPlanData>lambdaQuery();
        lambdaQuery.orderByAsc(StaffingPlanData::getId);
        lambdaQuery.eq(param.getRecordId() != null, StaffingPlanData::getRecordId, param.getRecordId());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getFirstLevelDepartment()), StaffingPlanData::getFirstLevelDepartment, param.getFirstLevelDepartment());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getSecondLevelDepartment()), StaffingPlanData::getSecondLevelDepartment, param.getSecondLevelDepartment());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getThirdLevelDepartment()), StaffingPlanData::getThirdLevelDepartment, param.getThirdLevelDepartment());
        lambdaQuery.eq(param.getDeptId() != null, StaffingPlanData::getDeptId, param.getDeptId());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getPosition()), StaffingPlanData::getPosition, param.getPosition());
//        lambdaQuery.eq(param.getLastYearStaffing() != null, StaffingPlanData::getLastYearStaffing, param.getLastYearStaffing());
//        lambdaQuery.eq(param.getThisYearStaffing() != null, StaffingPlanData::getThisYearStaffing, param.getThisYearStaffing());
//        lambdaQuery.eq(param.getNextYearStaffing() != null, StaffingPlanData::getNextYearStaffing, param.getNextYearStaffing());
//        lambdaQuery.eq(param.getM1FormalPlan() != null, StaffingPlanData::getM1FormalPlan, param.getM1FormalPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM1FormalActual()), StaffingPlanData::getM1FormalActual, param.getM1FormalActual());
//        lambdaQuery.eq(param.getM1PartPlan() != null, StaffingPlanData::getM1PartPlan, param.getM1PartPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM1PartActual()), StaffingPlanData::getM1PartActual, param.getM1PartActual());
//        lambdaQuery.eq(param.getM2FormalPlan() != null, StaffingPlanData::getM2FormalPlan, param.getM2FormalPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM2FormalActual()), StaffingPlanData::getM2FormalActual, param.getM2FormalActual());
//        lambdaQuery.eq(param.getM2PartPlan() != null, StaffingPlanData::getM2PartPlan, param.getM2PartPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM2PartActual()), StaffingPlanData::getM2PartActual, param.getM2PartActual());
//        lambdaQuery.eq(param.getM3FormalPlan() != null, StaffingPlanData::getM3FormalPlan, param.getM3FormalPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM3FormalActual()), StaffingPlanData::getM3FormalActual, param.getM3FormalActual());
//        lambdaQuery.eq(param.getM3PartPlan() != null, StaffingPlanData::getM3PartPlan, param.getM3PartPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM3PartActual()), StaffingPlanData::getM3PartActual, param.getM3PartActual());
//        lambdaQuery.eq(param.getM4FormalPlan() != null, StaffingPlanData::getM4FormalPlan, param.getM4FormalPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM4FormalActual()), StaffingPlanData::getM4FormalActual, param.getM4FormalActual());
//        lambdaQuery.eq(param.getM4PartPlan() != null, StaffingPlanData::getM4PartPlan, param.getM4PartPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM4PartActual()), StaffingPlanData::getM4PartActual, param.getM4PartActual());
//        lambdaQuery.eq(param.getM5FormalPlan() != null, StaffingPlanData::getM5FormalPlan, param.getM5FormalPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM5FormalActual()), StaffingPlanData::getM5FormalActual, param.getM5FormalActual());
//        lambdaQuery.eq(param.getM5PartPlan() != null, StaffingPlanData::getM5PartPlan, param.getM5PartPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM5PartActual()), StaffingPlanData::getM5PartActual, param.getM5PartActual());
//        lambdaQuery.eq(param.getM6FormalPlan() != null, StaffingPlanData::getM6FormalPlan, param.getM6FormalPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM6FormalActual()), StaffingPlanData::getM6FormalActual, param.getM6FormalActual());
//        lambdaQuery.eq(param.getM6PartPlan() != null, StaffingPlanData::getM6PartPlan, param.getM6PartPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM6PartActual()), StaffingPlanData::getM6PartActual, param.getM6PartActual());
//        lambdaQuery.eq(param.getM7FormalPlan() != null, StaffingPlanData::getM7FormalPlan, param.getM7FormalPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM7FormalActual()), StaffingPlanData::getM7FormalActual, param.getM7FormalActual());
//        lambdaQuery.eq(param.getM7PartPlan() != null, StaffingPlanData::getM7PartPlan, param.getM7PartPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM7PartActual()), StaffingPlanData::getM7PartActual, param.getM7PartActual());
//        lambdaQuery.eq(param.getM8FormalPlan() != null, StaffingPlanData::getM8FormalPlan, param.getM8FormalPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM8FormalActual()), StaffingPlanData::getM8FormalActual, param.getM8FormalActual());
//        lambdaQuery.eq(param.getM8PartPlan() != null, StaffingPlanData::getM8PartPlan, param.getM8PartPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM8PartActual()), StaffingPlanData::getM8PartActual, param.getM8PartActual());
//        lambdaQuery.eq(param.getM9FormalPlan() != null, StaffingPlanData::getM9FormalPlan, param.getM9FormalPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM9FormalActual()), StaffingPlanData::getM9FormalActual, param.getM9FormalActual());
//        lambdaQuery.eq(param.getM9PartPlan() != null, StaffingPlanData::getM9PartPlan, param.getM9PartPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM9PartActual()), StaffingPlanData::getM9PartActual, param.getM9PartActual());
//        lambdaQuery.eq(param.getM10FormalPlan() != null, StaffingPlanData::getM10FormalPlan, param.getM10FormalPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM10FormalActual()), StaffingPlanData::getM10FormalActual, param.getM10FormalActual());
//        lambdaQuery.eq(param.getM10PartPlan() != null, StaffingPlanData::getM10PartPlan, param.getM10PartPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM10PartActual()), StaffingPlanData::getM10PartActual, param.getM10PartActual());
//        lambdaQuery.eq(param.getM11FormalPlan() != null, StaffingPlanData::getM11FormalPlan, param.getM11FormalPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM11FormalActual()), StaffingPlanData::getM11FormalActual, param.getM11FormalActual());
//        lambdaQuery.eq(param.getM11PartPlan() != null, StaffingPlanData::getM11PartPlan, param.getM11PartPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM11PartActual()), StaffingPlanData::getM11PartActual, param.getM11PartActual());
//        lambdaQuery.eq(param.getM12FormalPlan() != null, StaffingPlanData::getM12FormalPlan, param.getM12FormalPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM12FormalActual()), StaffingPlanData::getM12FormalActual, param.getM12FormalActual());
//        lambdaQuery.eq(param.getM12PartPlan() != null, StaffingPlanData::getM12PartPlan, param.getM12PartPlan());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getM12PartActual()), StaffingPlanData::getM12PartActual, param.getM12PartActual());
//        lambdaQuery.eq(StrUtil.isNotBlank(param.getSummary()), StaffingPlanData::getSummary, param.getSummary());
        return lambdaQuery;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Response importStaffingPlanDataList(Long recordId, Stream<StaffingPlanDataImportVo> list) {
        List<StaffingPlanDataImportVo> errorList = new ArrayList<>();
        List<StaffingPlanData> successList = new ArrayList<>();
        Map<String, Long> deptNamesIdMap = employeeSysDeptServ.selectJoinDeptNamesForStaffingPlan();
//        List<StaffingPlanData> insertList = new ArrayList<>(successList.size());
        AtomicLong currentDeptId = new AtomicLong(0L);
        AtomicLong currentLv1DeptId = new AtomicLong(0L);
        list.forEach(item -> {
            item.validGroup(AddGroup.class);
            if (item.hasError()) {
                errorList.add(item);
                return;
            }
            StaffingPlanData staffingPlanData = MapstructUtils.convert(item, StaffingPlanData.class);
            if ("部门合计".equals(item.getPlate()) || "片区合计".equals(item.getPlate())) {
                staffingPlanData.setSummary("Y");
            } else {
                EmployeeDeptImportVo deptInfo = MapstructUtils.convert(item, EmployeeDeptImportVo.class);
                Pair<String, String> pair = employeeSysDeptServ.buildDeptNameStrForStaffingPlan(deptInfo);
                Long lv1DeptId = deptNamesIdMap.get(pair.getLeft());
                if (lv1DeptId == null) {
                    item.addError("一级部门不存在");
                    errorList.add(item);
                    return;
                }
                Long leafDeptId = deptNamesIdMap.get(pair.getRight());
                if (leafDeptId == null) {
                    item.addError("部门不存在");
                    errorList.add(item);
                    return;
                }
                currentDeptId.set(leafDeptId);
                currentLv1DeptId.set(lv1DeptId);
            }
            staffingPlanData.setRecordId(recordId);
            staffingPlanData.setDeptId(currentDeptId.get());
            staffingPlanData.setLv1DeptId(currentLv1DeptId.get());
            successList.add(staffingPlanData);
        });
        if (CollUtil.isNotEmpty(successList)) {

//            for (StaffingPlanDataImportVo importVo : successList) {


//                EmployeeInfo employeeInfo = MapstructUtils.convert(importVo, EmployeeInfo.class);
//                employeeInfo.setDeptId(leafDeptId);
//                employeeInfo.setStatus(employeeInfo.getEntryDate() == null
//                        ? HrStatusEnum.DRAFT.getStatus() : HrStatusEnum.ENTRY.getStatus());
//                employeeInfo.setPartTimeFlag(HrEmployeeConstants.YES);
//                EmployeeInfoCalcUtils.calcExpectedRegularDate(employeeInfo);
//                insertList.add(staffingPlanData);
//            }
            StaffingPlanRecords staffingPlanRecords = new StaffingPlanRecords();
            staffingPlanRecords.setId(recordId);
            staffingPlanRecords.setInitFlag(HrEmployeeConstants.YES);
            staffingPlanRecordsMapper.updateById(staffingPlanRecords);
            staffingPlanDataMapper.insert(successList);
        }
        StringBuilder message;
        if (CollUtil.isNotEmpty(errorList)) {
            ExcelContextHolder.setErrorExist();
            message = new StringBuilder("共" + errorList.size() + "条数据导入失败，错误如下：<br/>");
            errorList.forEach(item -> message.append(item.defaultFailMsg()));
            return Response.buildFailure(ResultCode.FAIL.getCode(), message.toString());
        } else {
            message = new StringBuilder("共" + successList.size() + "条数据导入成功");
            Response response = Response.buildSuccess();
            response.setErrMessage(message.toString());
            return response;
        }
    }

    @Override
    public List<StaffingPlanExportVo> exportList(Long recordId) {
        StaffingPlanRecords staffingPlanRecords = staffingPlanRecordsMapper.selectById(recordId);
        StaffingPlanExportVo staffingPlanExportVo = MapstructUtils.convert(staffingPlanRecords, StaffingPlanExportVo.class);
        StaffingPlanDataListParam param = new StaffingPlanDataListParam();
        param.setRecordId(recordId);
        List<StaffingPlanDataVo> staffingPlanDataVos = this.queryList(param);
        staffingPlanExportVo.setDataList(staffingPlanDataVos);
        return List.of(staffingPlanExportVo);
    }

    /**
     * 查询编制规划记录明细
     *
     * @param id 主键
     * @return 编制规划记录明细
     */
    @Override
    public StaffingPlanDataVo queryById(Long id){
        StaffingPlanData staffingPlanData = staffingPlanDataMapper.selectById(id);
        return MapstructUtils.convert(staffingPlanData, StaffingPlanDataVo.class);
    }

    /**
     * 新增编制规划记录明细
     *
     * @param param 编制规划记录明细
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByParam(StaffingPlanDataParam param) {
        StaffingPlanData staffingPlanData = MapstructUtils.convert(param, StaffingPlanData.class);
        return this.save(staffingPlanData);
    }

    /**
     * 修改编制规划记录明细
     *
     * @param param 编制规划记录明细
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByParam(List<StaffingPlanDataParam> param) {
        if (CollUtil.isEmpty(param)) {
            return false;
        }
        List<StaffingPlanData> staffingPlanDataList = MapstructUtils.convert(param, StaffingPlanData.class);
        return SqlHelper.retBool(staffingPlanDataMapper.updateById(staffingPlanDataList));
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(StaffingPlanData entity){
        // 做一些数据校验,如唯一约束
    }

    /**
     * 校验并批量删除编制规划记录明细信息
     *
     * @param ids 待删除的主键集合
     * @return 是否删除成功
     */
    @Override
//    @Transactional(rollbackFor = {Exception.class})
    public Boolean delByIds(List<Long> ids) {
        //做一些业务上的校验,判断是否需要校验
        return this.removeByIds(ids);
    }
}
