package com.anplus.hr.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cola.dto.PageResponse;
import com.anplus.hr.constant.HrStatusEnum;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.ContractExpirationReminderListParam;
import com.anplus.hr.domain.params.ContractExpirationReminderParam;
import com.anplus.hr.domain.vo.ContractExpirationReminderVo;
import com.anplus.hr.mapper.EmployeeInfoMapper;
import com.anplus.hr.service.ContractExpirationReminderServ;
import com.anplus.hr.service.EmployeeSysDeptServ;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import top.binfast.common.core.util.MapstructUtils;
import top.binfast.common.mybatis.util.QueryUtil;

import java.time.LocalDate;
import java.util.List;

/**
 * 员工合同续签提醒Service业务层处理
 *
 * @author LiuBin
 * @date 2025-11-20
 */
@RequiredArgsConstructor
@Service
public class ContractExpirationReminderServImpl extends ServiceImpl<EmployeeInfoMapper, EmployeeInfo> implements ContractExpirationReminderServ {

    private final EmployeeInfoMapper employeeInfoMapper;
    private final EmployeeSysDeptServ employeeSysDeptServ;

    /**
     * 分页查询员工合同续签提醒列表
     *
     * @param param 查询条件
     * @return 员工合同续签提醒分页列表
     */
    @Override
    public PageResponse<ContractExpirationReminderVo> queryPageList(ContractExpirationReminderListParam param) {
        Page<EmployeeInfo> page = QueryUtil.getPage(param);
        LambdaQueryWrapper<EmployeeInfo> lambdaQuery = this.buildQueryWrapper(param);
        employeeInfoMapper.selectPage(page, lambdaQuery);
        return QueryUtil.getPageResponse(page, MapstructUtils.convert(page.getRecords(), ContractExpirationReminderVo.class));
    }


    /**
     * 查询符合条件的员工合同续签提醒列表
     *
     * @param param 查询条件
     * @return 员工合同续签提醒列表
     */
    @Override
    public List<ContractExpirationReminderVo> queryList(ContractExpirationReminderListParam param) {
        LambdaQueryWrapper<EmployeeInfo> lambdaQuery = this.buildQueryWrapper(param);
        return MapstructUtils.convert(employeeInfoMapper.selectList(lambdaQuery), ContractExpirationReminderVo.class);
    }

    private LambdaQueryWrapper<EmployeeInfo> buildQueryWrapper(ContractExpirationReminderListParam param) {
        LambdaQueryWrapper<EmployeeInfo> lambdaQuery = Wrappers.<EmployeeInfo>lambdaQuery();
        lambdaQuery.orderByDesc(EmployeeInfo::getId);
        lambdaQuery.eq(EmployeeInfo::getStatus, HrStatusEnum.REGULARIZATION.getStatus());
        lambdaQuery.between(EmployeeInfo::getContractEndDate, LocalDate.now().minusMonths(1), LocalDate.now().plusMonths(1));
        lambdaQuery.eq(StrUtil.isNotBlank(param.getPlate()), EmployeeInfo::getPlate, param.getPlate());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getFirstLevelDepartment()), EmployeeInfo::getFirstLevelDepartment, param.getFirstLevelDepartment());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getSecondLevelDepartment()), EmployeeInfo::getSecondLevelDepartment, param.getSecondLevelDepartment());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getThirdLevelDepartment()), EmployeeInfo::getThirdLevelDepartment, param.getThirdLevelDepartment());
//        lambdaQuery.eq(param.getDeptId() != null, EmployeeInfo::getDeptId, param.getDeptId());
        if (ObjectUtil.isNotNull(param.getDeptId())) {
            //优先单部门搜索
            lambdaQuery.eq(EmployeeInfo::getDeptId, param.getDeptId());
        } else if (ObjectUtil.isNotNull(param.getBelongDeptId())) {
            //部门树搜索
            lambdaQuery.and(x -> {
                x.in(EmployeeInfo::getDeptId, employeeSysDeptServ.buildQueryWrapper(param.getBelongDeptId()));
            });
        }
        lambdaQuery.eq(StrUtil.isNotBlank(param.getPosition()), EmployeeInfo::getPosition, param.getPosition());
        lambdaQuery.like(StrUtil.isNotBlank(param.getName()), EmployeeInfo::getName, param.getName());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getPhoneNumber()), EmployeeInfo::getPhoneNumber, param.getPhoneNumber());
        lambdaQuery.eq(param.getContractStartDate() != null, EmployeeInfo::getContractStartDate, param.getContractStartDate());
        lambdaQuery.eq(param.getContractEndDate() != null, EmployeeInfo::getContractEndDate, param.getContractEndDate());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getContractForm()), EmployeeInfo::getContractForm, param.getContractForm());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getRemarks()), EmployeeInfo::getRemarks, param.getRemarks());
        return lambdaQuery;
    }

    /**
     * 查询员工合同续签提醒
     *
     * @param id 主键
     * @return 员工合同续签提醒
     */
    @Override
    public ContractExpirationReminderVo queryById(Long id) {
        EmployeeInfo contractExpirationReminder = employeeInfoMapper.selectById(id);
        return MapstructUtils.convert(contractExpirationReminder, ContractExpirationReminderVo.class);
    }

    /**
     * 新增员工合同续签提醒
     *
     * @param param 员工合同续签提醒
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByParam(ContractExpirationReminderParam param) {
//        EmployeeInfo contractExpirationReminder = MapstructUtils.convert(param, EmployeeInfo.class);
//        return this.save(contractExpirationReminder);
        return true;
    }

    /**
     * 修改员工合同续签提醒
     *
     * @param param 员工合同续签提醒
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByParam(ContractExpirationReminderParam param) {
//        EmployeeInfo contractExpirationReminder = MapstructUtils.convert(param, EmployeeInfo.class);
//        return this.updateById(contractExpirationReminder);
        return true;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(EmployeeInfo entity) {
        // 做一些数据校验,如唯一约束
    }

    /**
     * 校验并批量删除员工合同续签提醒信息
     *
     * @param ids 待删除的主键集合
     * @return 是否删除成功
     */
    @Override
//    @Transactional(rollbackFor = {Exception.class})
    public Boolean delByIds(List<Long> ids) {
        //做一些业务上的校验,判断是否需要校验
//        return this.removeByIds(ids);
        return true;
    }
}
