package com.anplus.hr.service;

import com.alibaba.cola.dto.Response;
import com.anplus.hr.domain.StaffingPlanData;
import com.anplus.hr.domain.vo.StaffingPlanDataImportVo;
import com.anplus.hr.domain.vo.StaffingPlanDataVo;
import com.anplus.hr.domain.params.StaffingPlanDataListParam;
import com.anplus.hr.domain.params.StaffingPlanDataParam;
import com.alibaba.cola.dto.PageResponse;
import com.anplus.hr.domain.vo.StaffingPlanExportVo;
import com.baomidou.mybatisplus.extension.service.IService;
import java.util.List;
import java.util.stream.Stream;

/**
 * 编制规划记录明细Service接口
 *
 * @author LiuBin
 * @date 2025-12-14
 */
public interface StaffingPlanDataServ extends IService<StaffingPlanData> {


    /**
     * 分页查询编制规划记录明细列表
     *
     * @param param        查询条件
     * @return 编制规划记录明细分页列表
     */
    PageResponse<StaffingPlanDataVo> queryPageList(StaffingPlanDataListParam param);

    /**
     * 查询符合条件的编制规划记录明细列表
     *
     * @param param 查询条件
     * @return 编制规划记录明细列表
     */
    List<StaffingPlanDataVo> queryList(StaffingPlanDataListParam param);

    List<StaffingPlanExportVo> exportList(Long recordId);

    /**
     * 导入编制规划记录明细列表
     *
     * @param stream        查询条件
     * @return 编制规划记录明细列表
     */
    Response importStaffingPlanDataList(Long recordId, Stream<StaffingPlanDataImportVo> stream);

    /**
     * 查询编制规划记录明细
     *
     * @param id 主键
     * @return 编制规划记录明细
     */
     StaffingPlanDataVo queryById(Long id);

    /**
     * 新增编制规划记录明细
     *
     * @param param 编制规划记录明细
     * @return 是否新增成功
     */
    Boolean insertByParam(StaffingPlanDataParam param);

    /**
     * 修改编制规划记录明细
     *
     * @param param 编制规划记录明细
     * @return 是否修改成功
     */
    Boolean updateByParam(List<StaffingPlanDataParam>  param);

    /**
     * 校验并批量删除编制规划记录明细信息
     *
     * @param ids     待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

}
