package com.anplus.hr.service;

import cn.hutool.core.util.StrUtil;
import com.anplus.hr.domain.vo.EmployeeDeptImportVo;
import com.anplus.hr.domain.vo.EmployeeInfoImportVo;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import top.binfast.app.biz.sysapi.bean.params.sysDept.SysDeptParam;
import top.binfast.app.biz.sysapi.bean.vo.sysDept.SysDeptDTO;

import java.util.List;
import java.util.Map;

/**
 * @author 刘斌
 * @date 2025/11/6 11:27
 */
public interface EmployeeSysDeptServ {

    /**
     * 根据部门id查询部门名称以及父级部门名称
     *
     * @param deptId 部门id
     */
    List<String> selectDeptNameAncestorsById(Long deptId);

    /**
     * 查询部门树结构
     */
    List<SysDeptDTO> selectDeptTreeForEmployee(SysDeptParam param);

    /**
     * 查询部门名称和叶子部门ID，部门名拼接成串作为key
     */
    Map<String, Long> selectJoinDeptNames();

    /**
     * 获取部门名称，拼接成xx/xx/xx/xx或xx/xx
     */
    Map<String, Long> selectJoinDeptNamesForStaffingPlan();

    /**
     * 构建部门查询条件
     *
     * @param belongDeptId 部门id
     */
    List<Long> buildQueryWrapper(Long belongDeptId);

    /**
     * 构建部门名称字符串
     *
     * @param importVo 导入数据
     * @return 部门名称字符串
     */
    default String buildDeptNameStr(EmployeeDeptImportVo importVo) {
        StringBuilder builder = new StringBuilder(importVo.getPlate());
        if (StrUtil.isNotBlank(importVo.getFirstLevelDepartment())) {
            builder.append(StrUtil.SLASH).append(importVo.getFirstLevelDepartment());
        }
        if (StrUtil.isNotBlank(importVo.getSecondLevelDepartment())) {
            builder.append(StrUtil.SLASH).append(importVo.getSecondLevelDepartment());
        }
        if (StrUtil.isNotBlank(importVo.getThirdLevelDepartment())) {
            builder.append(StrUtil.SLASH).append(importVo.getThirdLevelDepartment());
        }
        return builder.toString();
    }

    /**
     * 构建部门名称字符串
     *
     * @param importVo 导入数据
     * @return 部门名称字符串
     */
    default Pair<String, String> buildDeptNameStrForStaffingPlan(EmployeeDeptImportVo importVo) {
        String lv1DeptName = "";
        StringBuilder builder = new StringBuilder(importVo.getPlate());
        if (StrUtil.isNotBlank(importVo.getFirstLevelDepartment())) {
            builder.append(StrUtil.SLASH).append(importVo.getFirstLevelDepartment());
            lv1DeptName = builder.toString();
        }
        if (StrUtil.isNotBlank(importVo.getSecondLevelDepartment())) {
            builder.append(StrUtil.SLASH).append(importVo.getSecondLevelDepartment());
        }
        if (StrUtil.isNotBlank(importVo.getThirdLevelDepartment())) {
            builder.append(StrUtil.SLASH).append(importVo.getThirdLevelDepartment());
        }
        return new MutablePair<>(lv1DeptName, builder.toString());
    }

    /**
     * 构建部门名称字符串
     *
     * @param importVo 导入数据
     * @return 部门名称字符串
     */
    default String buildPartDeptNameStr(EmployeeDeptImportVo importVo) {
        StringBuilder builder = new StringBuilder(importVo.getConcurrentPlate());
        if (StrUtil.isNotBlank(importVo.getConcurrentFirstDept())) {
            builder.append(StrUtil.SLASH).append(importVo.getConcurrentFirstDept());
        }
        if (StrUtil.isNotBlank(importVo.getConcurrentSecondDept())) {
            builder.append(StrUtil.SLASH).append(importVo.getConcurrentSecondDept());
        }
        if (StrUtil.isNotBlank(importVo.getConcurrentThirdDept())) {
            builder.append(StrUtil.SLASH).append(importVo.getConcurrentThirdDept());
        }
        return builder.toString();
    }

}
