package com.anplus.hr.domain.vo;

import com.anplus.hr.domain.StaffingPlanData;
import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import cn.idev.excel.annotation.ExcelIgnore;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;



/**
 * 编制规划记录明细视图对象 staffing_plan_data
 *
 * @author LiuBin
 * @date 2025-12-14
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = StaffingPlanData.class)
public class StaffingPlanDataVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 板块
     */
    @ExcelProperty(value = "板块")
    private String plate;

    /**
     * 一级部门
     */
    @ExcelProperty(value = "一级部门")
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @ExcelProperty(value = "二级部门")
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    @ExcelProperty(value = "三级部门")
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
//    @ExcelProperty(value = "部门ID")
    private Long deptId;

    /**
     * 主岗位
     */
    @ExcelProperty(value = "主岗位")
    private String position;

    /**
     * 上一年编制
     */
    @ExcelProperty(value = "上一年编制")
    private Integer lastYearStaffing;

    /**
     * 今年编制
     */
    @ExcelProperty(value = "今年编制")
    private Integer thisYearStaffing;

    /**
     * 下一年编制
     */
    @ExcelProperty(value = "下一年编制")
    private Integer nextYearStaffing;

    /**
     * 1月正式工计划
     */
    @ExcelProperty(value = "1月正式工计划")
    private Integer m1FormalPlan;

    /**
     * 1月正式工实际
     */
    @ExcelProperty(value = "1月正式工实际")
    private String m1FormalActual;

    /**
     * 1月兼职计划
     */
    @ExcelProperty(value = "1月兼职计划")
    private Integer m1PartPlan;

    /**
     * 1月兼职实际
     */
    @ExcelProperty(value = "1月兼职实际")
    private String m1PartActual;

    /**
     * 2月正式工计划
     */
    @ExcelProperty(value = "2月正式工计划")
    private Integer m2FormalPlan;

    /**
     * 2月正式工实际
     */
    @ExcelProperty(value = "2月正式工实际")
    private String m2FormalActual;

    /**
     * 2月兼职计划
     */
    @ExcelProperty(value = "2月兼职计划")
    private Integer m2PartPlan;

    /**
     * 2月兼职实际
     */
    @ExcelProperty(value = "2月兼职实际")
    private String m2PartActual;

    /**
     * 3月正式工计划
     */
    @ExcelProperty(value = "3月正式工计划")
    private Integer m3FormalPlan;

    /**
     * 3月正式工实际
     */
    @ExcelProperty(value = "3月正式工实际")
    private String m3FormalActual;

    /**
     * 3月兼职计划
     */
    @ExcelProperty(value = "3月兼职计划")
    private Integer m3PartPlan;

    /**
     * 3月兼职实际
     */
    @ExcelProperty(value = "3月兼职实际")
    private String m3PartActual;

    /**
     * 4月正式工计划
     */
    @ExcelProperty(value = "4月正式工计划")
    private Integer m4FormalPlan;

    /**
     * 4月正式工实际
     */
    @ExcelProperty(value = "4月正式工实际")
    private String m4FormalActual;

    /**
     * 4月兼职计划
     */
    @ExcelProperty(value = "4月兼职计划")
    private Integer m4PartPlan;

    /**
     * 4月兼职实际
     */
    @ExcelProperty(value = "4月兼职实际")
    private String m4PartActual;

    /**
     * 5月正式工计划
     */
    @ExcelProperty(value = "5月正式工计划")
    private Integer m5FormalPlan;

    /**
     * 5月正式工实际
     */
    @ExcelProperty(value = "5月正式工实际")
    private String m5FormalActual;

    /**
     * 5月兼职计划
     */
    @ExcelProperty(value = "5月兼职计划")
    private Integer m5PartPlan;

    /**
     * 5月兼职实际
     */
    @ExcelProperty(value = "5月兼职实际")
    private String m5PartActual;

    /**
     * 6月正式工计划
     */
    @ExcelProperty(value = "6月正式工计划")
    private Integer m6FormalPlan;

    /**
     * 6月正式工实际
     */
    @ExcelProperty(value = "6月正式工实际")
    private String m6FormalActual;

    /**
     * 6月兼职计划
     */
    @ExcelProperty(value = "6月兼职计划")
    private Integer m6PartPlan;

    /**
     * 6月兼职实际
     */
    @ExcelProperty(value = "6月兼职实际")
    private String m6PartActual;

    /**
     * 7月正式工计划
     */
    @ExcelProperty(value = "7月正式工计划")
    private Integer m7FormalPlan;

    /**
     * 7月正式工实际
     */
    @ExcelProperty(value = "7月正式工实际")
    private String m7FormalActual;

    /**
     * 7月兼职计划
     */
    @ExcelProperty(value = "7月兼职计划")
    private Integer m7PartPlan;

    /**
     * 7月兼职实际
     */
    @ExcelProperty(value = "7月兼职实际")
    private String m7PartActual;

    /**
     * 8月正式工计划
     */
    @ExcelProperty(value = "8月正式工计划")
    private Integer m8FormalPlan;

    /**
     * 8月正式工实际
     */
    @ExcelProperty(value = "8月正式工实际")
    private String m8FormalActual;

    /**
     * 8月兼职计划
     */
    @ExcelProperty(value = "8月兼职计划")
    private Integer m8PartPlan;

    /**
     * 8月兼职实际
     */
    @ExcelProperty(value = "8月兼职实际")
    private String m8PartActual;

    /**
     * 9月正式工计划
     */
    @ExcelProperty(value = "9月正式工计划")
    private Integer m9FormalPlan;

    /**
     * 9月正式工实际
     */
    @ExcelProperty(value = "9月正式工实际")
    private String m9FormalActual;

    /**
     * 9月兼职计划
     */
    @ExcelProperty(value = "9月兼职计划")
    private Integer m9PartPlan;

    /**
     * 9月兼职实际
     */
    @ExcelProperty(value = "9月兼职实际")
    private String m9PartActual;

    /**
     * 10月正式工计划
     */
    @ExcelProperty(value = "10月正式工计划")
    private Integer m10FormalPlan;

    /**
     * 10月正式工实际
     */
    @ExcelProperty(value = "10月正式工实际")
    private String m10FormalActual;

    /**
     * 10月兼职计划
     */
    @ExcelProperty(value = "10月兼职计划")
    private Integer m10PartPlan;

    /**
     * 10月兼职实际
     */
    @ExcelProperty(value = "10月兼职实际")
    private String m10PartActual;

    /**
     * 11月正式工计划
     */
    @ExcelProperty(value = "11月正式工计划")
    private Integer m11FormalPlan;

    /**
     * 11月正式工实际
     */
    @ExcelProperty(value = "11月正式工实际")
    private String m11FormalActual;

    /**
     * 11月兼职计划
     */
    @ExcelProperty(value = "11月兼职计划")
    private Integer m11PartPlan;

    /**
     * 11月兼职实际
     */
    @ExcelProperty(value = "11月兼职实际")
    private String m11PartActual;

    /**
     * 12月正式工计划
     */
    @ExcelProperty(value = "12月正式工计划")
    private Integer m12FormalPlan;

    /**
     * 12月正式工实际
     */
    @ExcelProperty(value = "12月正式工实际")
    private String m12FormalActual;

    /**
     * 12月兼职计划
     */
    @ExcelProperty(value = "12月兼职计划")
    private Integer m12PartPlan;

    /**
     * 12月兼职实际
     */
    @ExcelProperty(value = "12月兼职实际")
    private String m12PartActual;

    /**
     * 合计行
     */
    @ExcelProperty(value = "合计行")
    private String summary;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


}
