package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.domain.StaffingPlanData;
import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Getter;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.excel.bean.ExcelBaseEntity;

import java.io.Serial;
import java.io.Serializable;

/**
 * @author 刘斌
 * @date 2025/12/15 10:27
 */
@Getter
@ExcelIgnoreUnannotated
@AutoMappers({
        @AutoMapper(target = StaffingPlanData.class, reverseConvertGenerate = false),
        @AutoMapper(target = EmployeeDeptImportVo.class, reverseConvertGenerate = false)
})
public class StaffingPlanDataImportVo extends ExcelBaseEntity implements Serializable {
    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 板块
     */
    @NotBlank(message = "板块不能为空", groups = {AddGroup.class})
    @ExcelProperty(index = 0)
    private String plate;

    /**
     * 一级部门
     */
//    @NotBlank(message = "一级部门不能为空", groups = {AddGroup.class})
    @ExcelProperty(index = 1)
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
//    @NotBlank(message = "二级部门不能为空", groups = {AddGroup.class})
    @ExcelProperty(index = 2)
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
//    @NotBlank(message = "三级部门不能为空", groups = {AddGroup.class})
    @ExcelProperty(index = 3)
    private String thirdLevelDepartment;

//    /**
//     * 部门ID
//     */
//    @ExcelProperty(value = "部门ID")
//    private Long deptId;

    /**
     * 岗位名称
     */
//    @NotBlank(message = "岗位名称不能为空", groups = {AddGroup.class})
    @ExcelProperty(index = 4)
    private String position;

    /**
     * 上一年编制
     */
    @NotNull(message = "上一年编制不能为空", groups = {AddGroup.class})
    @ExcelProperty(index = 5)
    private Integer lastYearStaffing;

    /**
     * 今年编制
     */
    @NotNull(message = "今年编制不能为空", groups = {AddGroup.class})
    @ExcelProperty(index = 6)
    private Integer thisYearStaffing;

    /**
     * 下一年编制
     */
    @NotNull(message = "下一年编制不能为空", groups = {AddGroup.class})
    @ExcelProperty(index = 7)
    private Integer nextYearStaffing;

    /**
     * 1月正式工计划
     */
    @ExcelProperty(value = "1月正式工计划")
    private Integer m1FormalPlan;

//    /**
//     * 1月正式工实际
//     */
//    @ExcelProperty(value = "1月正式工实际")
//    private String m1FormalActual;

    /**
     * 1月兼职计划
     */
    @ExcelProperty(value = "1月兼职计划")
    private Integer m1PartPlan;

//    /**
//     * 1月兼职实际
//     */
//    @ExcelProperty(value = "1月兼职实际")
//    private String m1PartActual;

    /**
     * 2月正式工计划
     */
    @ExcelProperty(value = "2月正式工计划")
    private Integer m2FormalPlan;

//    /**
//     * 2月正式工实际
//     */
//    @ExcelProperty(value = "2月正式工实际")
//    private String m2FormalActual;

    /**
     * 2月兼职计划
     */
    @ExcelProperty(value = "2月兼职计划")
    private Integer m2PartPlan;

//    /**
//     * 2月兼职实际
//     */
//    @ExcelProperty(value = "2月兼职实际")
//    private String m2PartActual;

    /**
     * 3月正式工计划
     */
    @ExcelProperty(value = "3月正式工计划")
    private Integer m3FormalPlan;

//    /**
//     * 3月正式工实际
//     */
//    @ExcelProperty(value = "3月正式工实际")
//    private String m3FormalActual;

    /**
     * 3月兼职计划
     */
    @ExcelProperty(value = "3月兼职计划")
    private Integer m3PartPlan;

//    /**
//     * 3月兼职实际
//     */
//    @ExcelProperty(value = "3月兼职实际")
//    private String m3PartActual;

    /**
     * 4月正式工计划
     */
    @ExcelProperty(value = "4月正式工计划")
    private Integer m4FormalPlan;

//    /**
//     * 4月正式工实际
//     */
//    @ExcelProperty(value = "4月正式工实际")
//    private String m4FormalActual;

    /**
     * 4月兼职计划
     */
    @ExcelProperty(value = "4月兼职计划")
    private Integer m4PartPlan;

//    /**
//     * 4月兼职实际
//     */
//    @ExcelProperty(value = "4月兼职实际")
//    private String m4PartActual;

    /**
     * 5月正式工计划
     */
    @ExcelProperty(value = "5月正式工计划")
    private Integer m5FormalPlan;

//    /**
//     * 5月正式工实际
//     */
//    @ExcelProperty(value = "5月正式工实际")
//    private String m5FormalActual;

    /**
     * 5月兼职计划
     */
    @ExcelProperty(value = "5月兼职计划")
    private Integer m5PartPlan;

//    /**
//     * 5月兼职实际
//     */
//    @ExcelProperty(value = "5月兼职实际")
//    private String m5PartActual;

    /**
     * 6月正式工计划
     */
    @ExcelProperty(value = "6月正式工计划")
    private Integer m6FormalPlan;

//    /**
//     * 6月正式工实际
//     */
//    @ExcelProperty(value = "6月正式工实际")
//    private String m6FormalActual;

    /**
     * 6月兼职计划
     */
    @ExcelProperty(value = "6月兼职计划")
    private Integer m6PartPlan;

//    /**
//     * 6月兼职实际
//     */
//    @ExcelProperty(value = "6月兼职实际")
//    private String m6PartActual;

    /**
     * 7月正式工计划
     */
    @ExcelProperty(value = "7月正式工计划")
    private Integer m7FormalPlan;

//    /**
//     * 7月正式工实际
//     */
//    @ExcelProperty(value = "7月正式工实际")
//    private String m7FormalActual;

    /**
     * 7月兼职计划
     */
    @ExcelProperty(value = "7月兼职计划")
    private Integer m7PartPlan;

//    /**
//     * 7月兼职实际
//     */
//    @ExcelProperty(value = "7月兼职实际")
//    private String m7PartActual;

    /**
     * 8月正式工计划
     */
    @ExcelProperty(value = "8月正式工计划")
    private Integer m8FormalPlan;

//    /**
//     * 8月正式工实际
//     */
//    @ExcelProperty(value = "8月正式工实际")
//    private String m8FormalActual;

    /**
     * 8月兼职计划
     */
    @ExcelProperty(value = "8月兼职计划")
    private Integer m8PartPlan;

//    /**
//     * 8月兼职实际
//     */
//    @ExcelProperty(value = "8月兼职实际")
//    private String m8PartActual;

    /**
     * 9月正式工计划
     */
    @ExcelProperty(value = "9月正式工计划")
    private Integer m9FormalPlan;

//    /**
//     * 9月正式工实际
//     */
//    @ExcelProperty(value = "9月正式工实际")
//    private String m9FormalActual;

    /**
     * 9月兼职计划
     */
    @ExcelProperty(value = "9月兼职计划")
    private Integer m9PartPlan;

//    /**
//     * 9月兼职实际
//     */
//    @ExcelProperty(value = "9月兼职实际")
//    private String m9PartActual;

    /**
     * 10月正式工计划
     */
    @ExcelProperty(value = "10月正式工计划")
    private Integer m10FormalPlan;

//    /**
//     * 10月正式工实际
//     */
//    @ExcelProperty(value = "10月正式工实际")
//    private String m10FormalActual;

    /**
     * 10月兼职计划
     */
    @ExcelProperty(value = "10月兼职计划")
    private Integer m10PartPlan;

//    /**
//     * 10月兼职实际
//     */
//    @ExcelProperty(value = "10月兼职实际")
//    private String m10PartActual;

    /**
     * 11月正式工计划
     */
    @ExcelProperty(value = "11月正式工计划")
    private Integer m11FormalPlan;

//    /**
//     * 11月正式工实际
//     */
//    @ExcelProperty(value = "11月正式工实际")
//    private String m11FormalActual;

    /**
     * 11月兼职计划
     */
    @ExcelProperty(value = "11月兼职计划")
    private Integer m11PartPlan;

//    /**
//     * 11月兼职实际
//     */
//    @ExcelProperty(value = "11月兼职实际")
//    private String m11PartActual;

    /**
     * 12月正式工计划
     */
    @ExcelProperty(value = "12月正式工计划")
    private Integer m12FormalPlan;

//    /**
//     * 12月正式工实际
//     */
//    @ExcelProperty(value = "12月正式工实际")
//    private String m12FormalActual;

    /**
     * 12月兼职计划
     */
    @ExcelProperty(value = "12月兼职计划")
    private Integer m12PartPlan;

//    /**
//     * 12月兼职实际
//     */
//    @ExcelProperty(value = "12月兼职实际")
//    private String m12PartActual;

    /**
     * 备注
     */
    @ExcelProperty(index = 35)
    private String remark;

    public void setPlate(String plate) {
        this.plate = plate == null ? null : plate.trim();
    }

    public void setFirstLevelDepartment(String firstLevelDepartment) {
        this.firstLevelDepartment = firstLevelDepartment == null ? null : firstLevelDepartment.trim();
    }

    public void setSecondLevelDepartment(String secondLevelDepartment) {
        this.secondLevelDepartment = secondLevelDepartment == null ? null : secondLevelDepartment.trim();
    }

    public void setThirdLevelDepartment(String thirdLevelDepartment) {
        this.thirdLevelDepartment = thirdLevelDepartment == null ? null : thirdLevelDepartment.trim();
    }

    public void setPosition(String position) {
        this.position = position == null ? null : position.trim();
    }

    public void setLastYearStaffing(Integer lastYearStaffing) {
        this.lastYearStaffing = lastYearStaffing;
    }

    public void setThisYearStaffing(Integer thisYearStaffing) {
        this.thisYearStaffing = thisYearStaffing;
    }

    public void setNextYearStaffing(Integer nextYearStaffing) {
        this.nextYearStaffing = nextYearStaffing;
    }

    public void setM1FormalPlan(Integer m1FormalPlan) {
        this.m1FormalPlan = m1FormalPlan;
    }

    public void setM1PartPlan(Integer m1PartPlan) {
        this.m1PartPlan = m1PartPlan;
    }

    public void setM2FormalPlan(Integer m2FormalPlan) {
        this.m2FormalPlan = m2FormalPlan;
    }

    public void setM2PartPlan(Integer m2PartPlan) {
        this.m2PartPlan = m2PartPlan;
    }

    public void setM3FormalPlan(Integer m3FormalPlan) {
        this.m3FormalPlan = m3FormalPlan;
    }

    public void setM3PartPlan(Integer m3PartPlan) {
        this.m3PartPlan = m3PartPlan;
    }

    public void setM4FormalPlan(Integer m4FormalPlan) {
        this.m4FormalPlan = m4FormalPlan;
    }

    public void setM4PartPlan(Integer m4PartPlan) {
        this.m4PartPlan = m4PartPlan;
    }

    public void setM5FormalPlan(Integer m5FormalPlan) {
        this.m5FormalPlan = m5FormalPlan;
    }

    public void setM5PartPlan(Integer m5PartPlan) {
        this.m5PartPlan = m5PartPlan;
    }

    public void setM6FormalPlan(Integer m6FormalPlan) {
        this.m6FormalPlan = m6FormalPlan;
    }

    public void setM6PartPlan(Integer m6PartPlan) {
        this.m6PartPlan = m6PartPlan;
    }

    public void setM7FormalPlan(Integer m7FormalPlan) {
        this.m7FormalPlan = m7FormalPlan;
    }

    public void setM7PartPlan(Integer m7PartPlan) {
        this.m7PartPlan = m7PartPlan;
    }

    public void setM8FormalPlan(Integer m8FormalPlan) {
        this.m8FormalPlan = m8FormalPlan;
    }

    public void setM8PartPlan(Integer m8PartPlan) {
        this.m8PartPlan = m8PartPlan;
    }

    public void setM9FormalPlan(Integer m9FormalPlan) {
        this.m9FormalPlan = m9FormalPlan;
    }

    public void setM9PartPlan(Integer m9PartPlan) {
        this.m9PartPlan = m9PartPlan;
    }

    public void setM10FormalPlan(Integer m10FormalPlan) {
        this.m10FormalPlan = m10FormalPlan;
    }

    public void setM10PartPlan(Integer m10PartPlan) {
        this.m10PartPlan = m10PartPlan;
    }

    public void setM11FormalPlan(Integer m11FormalPlan) {
        this.m11FormalPlan = m11FormalPlan;
    }

    public void setM11PartPlan(Integer m11PartPlan) {
        this.m11PartPlan = m11PartPlan;
    }

    public void setM12FormalPlan(Integer m12FormalPlan) {
        this.m12FormalPlan = m12FormalPlan;
    }

    public void setM12PartPlan(Integer m12PartPlan) {
        this.m12PartPlan = m12PartPlan;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }
}
