package com.anplus.hr.domain.params;

import com.anplus.hr.domain.StaffingPlanData;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import jakarta.validation.constraints.*;

/**
 * 编制规划记录明细业务对象 staffing_plan_data
 *
 * @author LiuBin
 * @date 2025-12-14
 */
@Data
@AutoMapper(target = StaffingPlanData.class, reverseConvertGenerate = false)
public class StaffingPlanDataParam {

    /**
     * 主键
     */
    @NotNull(message = "主键不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 板块
     */
    @NotBlank(message = "板块不能为空", groups = { AddGroup.class, EditGroup.class })
    private String plate;

    /**
     * 一级部门
     */
//    @NotBlank(message = "一级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
//    @NotBlank(message = "二级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
//    @NotBlank(message = "三级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
//    @NotNull(message = "部门ID不能为空", groups = { AddGroup.class, EditGroup.class })
//    private Long deptId;

    /**
     * 主岗位
     */
//    @NotBlank(message = "主岗位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String position;

    /**
     * 上一年编制
     */
//    @NotNull(message = "上一年编制不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer lastYearStaffing;

    /**
     * 今年编制
     */
//    @NotNull(message = "今年编制不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer thisYearStaffing;

    /**
     * 下一年编制
     */
//    @NotNull(message = "下一年编制不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer nextYearStaffing;

    /**
     * 1月正式工计划
     */
//    @NotNull(message = "1月正式工计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m1FormalPlan;

    /**
     * 1月正式工实际
     */
//    @NotBlank(message = "1月正式工实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m1FormalActual;

    /**
     * 1月兼职计划
     */
//    @NotNull(message = "1月兼职计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m1PartPlan;

    /**
     * 1月兼职实际
     */
//    @NotBlank(message = "1月兼职实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m1PartActual;

    /**
     * 2月正式工计划
     */
//    @NotNull(message = "2月正式工计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m2FormalPlan;

    /**
     * 2月正式工实际
     */
//    @NotBlank(message = "2月正式工实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m2FormalActual;

    /**
     * 2月兼职计划
     */
//    @NotNull(message = "2月兼职计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m2PartPlan;

    /**
     * 2月兼职实际
     */
//    @NotBlank(message = "2月兼职实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m2PartActual;

    /**
     * 3月正式工计划
     */
//    @NotNull(message = "3月正式工计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m3FormalPlan;

    /**
     * 3月正式工实际
     */
//    @NotBlank(message = "3月正式工实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m3FormalActual;

    /**
     * 3月兼职计划
     */
//    @NotNull(message = "3月兼职计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m3PartPlan;

    /**
     * 3月兼职实际
     */
//    @NotBlank(message = "3月兼职实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m3PartActual;

    /**
     * 4月正式工计划
     */
//    @NotNull(message = "4月正式工计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m4FormalPlan;

    /**
     * 4月正式工实际
     */
//    @NotBlank(message = "4月正式工实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m4FormalActual;

    /**
     * 4月兼职计划
     */
//    @NotNull(message = "4月兼职计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m4PartPlan;

    /**
     * 4月兼职实际
     */
//    @NotBlank(message = "4月兼职实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m4PartActual;

    /**
     * 5月正式工计划
     */
//    @NotNull(message = "5月正式工计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m5FormalPlan;

    /**
     * 5月正式工实际
     */
//    @NotBlank(message = "5月正式工实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m5FormalActual;

    /**
     * 5月兼职计划
     */
//    @NotNull(message = "5月兼职计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m5PartPlan;

    /**
     * 5月兼职实际
     */
//    @NotBlank(message = "5月兼职实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m5PartActual;

    /**
     * 6月正式工计划
     */
//    @NotNull(message = "6月正式工计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m6FormalPlan;

    /**
     * 6月正式工实际
     */
//    @NotBlank(message = "6月正式工实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m6FormalActual;

    /**
     * 6月兼职计划
     */
//    @NotNull(message = "6月兼职计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m6PartPlan;

    /**
     * 6月兼职实际
     */
//    @NotBlank(message = "6月兼职实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m6PartActual;

    /**
     * 7月正式工计划
     */
//    @NotNull(message = "7月正式工计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m7FormalPlan;

    /**
     * 7月正式工实际
     */
//    @NotBlank(message = "7月正式工实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m7FormalActual;

    /**
     * 7月兼职计划
     */
//    @NotNull(message = "7月兼职计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m7PartPlan;

    /**
     * 7月兼职实际
     */
//    @NotBlank(message = "7月兼职实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m7PartActual;

    /**
     * 8月正式工计划
     */
//    @NotNull(message = "8月正式工计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m8FormalPlan;

    /**
     * 8月正式工实际
     */
//    @NotBlank(message = "8月正式工实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m8FormalActual;

    /**
     * 8月兼职计划
     */
//    @NotNull(message = "8月兼职计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m8PartPlan;

    /**
     * 8月兼职实际
     */
//    @NotBlank(message = "8月兼职实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m8PartActual;

    /**
     * 9月正式工计划
     */
//    @NotNull(message = "9月正式工计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m9FormalPlan;

    /**
     * 9月正式工实际
     */
//    @NotBlank(message = "9月正式工实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m9FormalActual;

    /**
     * 9月兼职计划
     */
//    @NotNull(message = "9月兼职计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m9PartPlan;

    /**
     * 9月兼职实际
     */
//    @NotBlank(message = "9月兼职实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m9PartActual;

    /**
     * 10月正式工计划
     */
//    @NotNull(message = "10月正式工计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m10FormalPlan;

    /**
     * 10月正式工实际
     */
//    @NotBlank(message = "10月正式工实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m10FormalActual;

    /**
     * 10月兼职计划
     */
//    @NotNull(message = "10月兼职计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m10PartPlan;

    /**
     * 10月兼职实际
     */
//    @NotBlank(message = "10月兼职实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m10PartActual;

    /**
     * 11月正式工计划
     */
//    @NotNull(message = "11月正式工计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m11FormalPlan;

    /**
     * 11月正式工实际
     */
//    @NotBlank(message = "11月正式工实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m11FormalActual;

    /**
     * 11月兼职计划
     */
//    @NotNull(message = "11月兼职计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m11PartPlan;

    /**
     * 11月兼职实际
     */
//    @NotBlank(message = "11月兼职实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m11PartActual;

    /**
     * 12月正式工计划
     */
//    @NotNull(message = "12月正式工计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m12FormalPlan;

    /**
     * 12月正式工实际
     */
//    @NotBlank(message = "12月正式工实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m12FormalActual;

    /**
     * 12月兼职计划
     */
//    @NotNull(message = "12月兼职计划不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer m12PartPlan;

    /**
     * 12月兼职实际
     */
//    @NotBlank(message = "12月兼职实际不能为空", groups = { AddGroup.class, EditGroup.class })
    private String m12PartActual;

//    /**
//     * 合计行
//     */
//    @NotBlank(message = "合计行不能为空", groups = { AddGroup.class, EditGroup.class })
//    private String summary;

    /**
     * 备注
     */
//    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;


}
