package com.anplus.hr.domain.params;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.time.LocalDate;

/**
 * 转正申请参数
 * @author 刘斌
 * @date 2025/11/18 11:27
 *
 * ！！！需要自动填写的字段！！！
 * 员工类型：转正员工
 * 用工形式：正式工
 * 合同形式：新签
 * 劳动合同期限：开始时间-结束时间（废弃！）
 * 合同到期提醒：结束时间减一个月（废弃！）
 */
@Data
public class EmployeeRegularApplyParam {

    private Long id;

    /**
     * 员工id
     */
    @NotNull(message = "员工不能为空")
    private Long employeeId;

//    /**
//     * 劳动合同开始时间
//     */
//    @NotNull(message = "劳动合同开始时间")
//    private LocalDate contractStartDate;
//
//    /**
//     * 劳动合同截止时间
//     */
//    @NotNull(message = "劳动合同截止时间")
//    private LocalDate contractEndDate;
//
//    /**
//     * 劳动合同签订情况
//     */
//    private String contractSigningStatus;
//
//    /**
//     * 合同主体
//     */
//    private String contractEntity;

    /**
     * 转正时间
     */
    private LocalDate regularizationDate;

    /**
     * 社保主体
     */
    private String socialSecurityEntity;

    /**
     * 是否缴纳社保
     */
    private String hasSocialSecurityPaid;

    /**
     * 公积金主体
     */
    private String providentFundEntity;

    /**
     * 是否缴纳公积金
     */
    private String hasProvidentFundPaid;

    /**
     * 是否缴纳雇主险
     */
    private String hasEmployerInsurancePaid;


    private String remark;
}
