package com.anplus.hr.domain.params;

import lombok.Getter;
import lombok.Setter;
import top.binfast.common.core.bean.params.PageQueryParam;
import java.util.HashMap;
import java.util.Map;
import java.time.LocalDate;

/**
 * 兼职员工信息分页对象 employee_part_time_info
 *
 * @author LiuBin
 * @date 2025-12-10
 */
@Getter
@Setter
public class EmployeePartTimeInfoListParam extends PageQueryParam {

    /**
     * 板块
     */
    private String plate;

    /**
     * 一级部门
     */
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    private Long deptId;

    /**
     * 岗位类型
     */
    private String positionType;

    /**
     * 主岗位
     */
    private String position;

    /**
     * 姓名
     */
    private String name;

    /**
     * 性别
     */
    private String gender;

    /**
     * 身份证号码
     */
    private String idCardNumber;

    /**
     * 照片ID
     */
    private Long ossId;

    /**
     * 出生日期
     */
    private LocalDate birthDate;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 籍贯
     */
    private String nativePlace;

    /**
     * 民族
     */
    private String ethnicity;

    /**
     * 婚姻状况
     */
    private String maritalStatus;

    /**
     * 政治面貌
     */
    private String politicalStatus;

    /**
     * 手机号码
     */
    private String phoneNumber;

    /**
     * 紧急联系人
     */
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    private String homeAddress;

    /**
     * 入职时间
     */
    private LocalDate entryDate;

    /**
     * 全日制学历
     */
    private String fulltimeEducation;

    /**
     * 全日制毕业院校
     */
    private String fulltimeSchool;

    /**
     * 全日制专业
     */
    private String fulltimeMajor;

    /**
     * 全日制毕业日期
     */
    private LocalDate fulltimeGraduationDate;

    /**
     * 全日制学位
     */
    private String fulltimeDegree;

    /**
     * 用工形式
     */
    private String employmentForm;

    /**
     * 是否兼职
     */
    private String partTimeFlag;

    /**
     * 签订兼职协议
     */
    private String partTimeAgreement;

    /**
     * 协议主体
     */
    private String agreementEntity;

    /**
     * 协议期限
     */
    private String agreementPeriod;

    /**
     * 协议开始时间
     */
    private LocalDate agreementStartDate;

    /**
     * 协议截止时间
     */
    private LocalDate agreementEndDate;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 银行卡号
     */
    private String bankCardNumber;

    /**
     * 开户行
     */
    private String bankName;

    /**
     * 公司内是否有亲属关系
     */
    private String hasRelativeInCompany;

    /**
     * 亲属姓名
     */
    private String relativeName;

    /**
     * 介绍人
     */
    private String introducer;

    /**
     * 介绍人关系
     */
    private String introducerRelation;

    /**
     * 工资发放地
     */
    private String salaryLocation;

    /**
     * 成本费用所属
     */
    private String costOfDept;

    /**
     * 归属部门id（部门树）
     */
    private Long belongDeptId;


    private Map<String, Object> params = new HashMap<>();

}
