package com.anplus.hr.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import com.alibaba.cola.dto.PageResponse;
import com.anplus.hr.domain.params.ContractExpirationReminderListParam;
import com.anplus.hr.domain.vo.ContractExpirationReminderVo;
import com.anplus.hr.service.ContractExpirationReminderServ;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import top.binfast.common.core.constant.BusinessType;
import top.binfast.common.excel.annotion.ExcelExport;
import top.binfast.common.log.annotation.PinSysLog;

import java.util.List;

/**
 * 员工合同续签提醒
 *
 * @author LiuBin
 * @date 2025-11-20
 */
@Validated
@RestController
@RequestMapping("/employee/contractExpiration")
public class ContractExpirationReminderCtrl {

    @Resource
    private ContractExpirationReminderServ contractExpirationReminderServ;

    /**
     * 查询员工合同续签提醒列表
     */
    @SaCheckPermission("employee:contractExpiration:list")
    @GetMapping("/page")
    public PageResponse<ContractExpirationReminderVo> pageList(ContractExpirationReminderListParam param) {
        return contractExpirationReminderServ.queryPageList(param);
    }

    /**
     * 导出员工合同续签提醒列表
     */
    @ExcelExport
    @SaCheckPermission("employee:contractExpiration:export")
    @PinSysLog(value = "员工合同续签提醒", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public List<ContractExpirationReminderVo> export(ContractExpirationReminderListParam param) {
        return contractExpirationReminderServ.queryList(param);
    }

//    /**
//     * 获取员工合同续签提醒详细信息
//     *
//     * @param id 主键
//     */
//    @SaCheckPermission("employee:contractExpirationReminder:query")
//    @GetMapping("/{id}")
//    public SingleResponse<ContractExpirationReminderVo> getDetail(@PathVariable @Min(1)
//                                                                  Long id) {
//        return SingleResponse.of(contractExpirationReminderServ.queryById(id));
//    }
//
//    /**
//     * 新增员工合同续签提醒
//     */
//    @SaCheckPermission("employee:contractExpirationReminder:add")
//    @PinSysLog(value = "员工合同续签提醒", businessType = BusinessType.INSERT)
//    @PostMapping()
//    public Response add(@Validated(AddGroup.class) @RequestBody ContractExpirationReminderParam param) {
//        return ResponseUtils.ofResult(contractExpirationReminderServ.insertByParam(param));
//    }
//
//    /**
//     * 修改员工合同续签提醒
//     */
//    @SaCheckPermission("employee:contractExpirationReminder:edit")
//    @PinSysLog(value = "员工合同续签提醒", businessType = BusinessType.UPDATE)
//    @PutMapping()
//    public Response edit(@Validated(EditGroup.class) @RequestBody ContractExpirationReminderParam param) {
//        return ResponseUtils.ofResult(contractExpirationReminderServ.updateByParam(param));
//    }
//
//    /**
//     * 删除员工合同续签提醒
//     *
//     * @param ids 主键串
//     */
//    @SaCheckPermission("employee:contractExpirationReminder:remove")
//    @PinSysLog(value = "员工合同续签提醒", businessType = BusinessType.DELETE)
//    @DeleteMapping("/{ids}")
//    public Response remove(@NotEmpty(message = "主键不能为空")
//                           @PathVariable Long[] ids) {
//        return ResponseUtils.ofResult(contractExpirationReminderServ.delByIds(List.of(ids)));
//    }
}