package com.anplus.hr.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author 刘斌
 * @date 2025/11/17 11:12
 */
@Getter
@AllArgsConstructor
public enum HrYearsOfServiceSegmentEnum {

    UNDER_TWO("1", "<2年", 24),
    TWO_TO_FIVE("2", "≥2年＜5年", 60),
    FIVE_TO_TEN("3", "≥5年＜10年", 120),
    OVER_TEN("4", "≥10年以上", 1200);

    private final String code;

    private final String name;

    private final int monthsLimit;


    public static HrYearsOfServiceSegmentEnum getByTotalMonths(Integer totalMonths) {
        if (totalMonths == null || totalMonths <= 0) {
            return null;
        }
        for (HrYearsOfServiceSegmentEnum value : values()) {
            if (totalMonths < value.monthsLimit) {
                return value;
            }
        }
        return null;
    }
}
