package com.anplus.hr.service.impl.command;

import cn.hutool.core.collection.CollUtil;
import com.anplus.hr.constant.HrEmployeeConstants;
import com.anplus.hr.domain.EmployeeFamilyMembers;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.EmployeeFamilyMembersParam;
import com.anplus.hr.domain.vo.EmployeeFamilyMembersVo;
import com.anplus.hr.domain.vo.EmployeeInfoVo;
import com.anplus.hr.mapper.EmployeeFamilyMembersMapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import lombok.RequiredArgsConstructor;
import org.dromara.trans.service.impl.TransService;
import org.springframework.stereotype.Component;
import top.binfast.common.core.util.LambdaUtil;
import top.binfast.common.core.util.MapstructUtils;
import top.binfast.common.mybatis.bean.model.BaseModel;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author 刘斌
 * @date 2025/12/4 16:41
 */
@RequiredArgsConstructor
@Component
public class EmployeeFamilyMembersCmdExe {

    private final EmployeeFamilyMembersMapper employeeFamilyMembersMapper;
    private final TransService transService;

    /**
     * 更新紧急联系人等
     */
    public void updateEmergencyInfo(List<EmployeeFamilyMembersParam> familyMembers, EmployeeInfo employeeInfo) {
        if (CollUtil.isEmpty(familyMembers)) {
            return;
        }
        for (EmployeeFamilyMembersParam familyMember : familyMembers) {
            if (HrEmployeeConstants.YES.equals(familyMember.getEmergencyFlag())) {
                employeeInfo.setEmergencyContact(familyMember.getName());
                employeeInfo.setEmergencyContactPhone(familyMember.getContact());
            }
        }
    }

    /**
     * 批量插入
     */
    public boolean insertByEmployee(List<EmployeeFamilyMembersParam> familyMembers, EmployeeInfo employeeInfo) {
        if (CollUtil.isEmpty(familyMembers)) {
            return false;
        }
        Long employeeId = employeeInfo.getId();
        Long tenantId = employeeInfo.getTenantId();
        List<EmployeeFamilyMembers> employeeFamilyMembers = MapstructUtils.convert(familyMembers, EmployeeFamilyMembers.class);
        for (EmployeeFamilyMembers employeeFamilyMember : employeeFamilyMembers) {
            employeeFamilyMember.setEmployeeId(employeeId);
            employeeFamilyMember.setTenantId(tenantId);
        }
        return SqlHelper.retBool(employeeFamilyMembersMapper.insertOrUpdate(employeeFamilyMembers));
    }

    /**
     * 批量更新
     */
    public boolean updateByEmployee(List<EmployeeFamilyMembersParam> familyMembers, EmployeeInfo employeeInfo) {
        if (CollUtil.isEmpty(familyMembers)) {
            return false;
        }
        Long employeeId = employeeInfo.getId();
        List<EmployeeFamilyMembers> exitFamilyMembersList = employeeFamilyMembersMapper.selectByEmployeeId(employeeId);
        if (CollUtil.isNotEmpty(exitFamilyMembersList)) {
            Map<Long, Boolean> updateMap = LambdaUtil.filterToMap(familyMembers, (t) -> t.getId() != null, EmployeeFamilyMembersParam::getId, (t) -> true);
            List<Long> deleteIdList = exitFamilyMembersList.stream()
                    .map(BaseModel::getId)
                    .filter(id -> updateMap.get(id) == null)
                    .collect(Collectors.toList());
            employeeFamilyMembersMapper.deleteByIds(deleteIdList);
        }
//        boolean exists = employeeFamilyMembersMapper.exists(new LambdaUpdateWrapper<EmployeeFamilyMembers>()
//                .eq(EmployeeFamilyMembers::getEmployeeId, employeeId));
//        if (exists) {
//            employeeFamilyMembersMapper.deleteByEmployeeId(employeeId);
//        }
        return insertByEmployee(familyMembers, employeeInfo);
    }

    /**
     * 根据员工id赋值家庭成员信息
     */
    public void setFamilyMembersData(EmployeeInfoVo employeeInfoVo) {
        List<EmployeeFamilyMembers> familyMembers = employeeFamilyMembersMapper.selectByEmployeeId(employeeInfoVo.getId());
        if (CollUtil.isNotEmpty(familyMembers)) {
            List<EmployeeFamilyMembersVo> familyMembersVos = MapstructUtils.convert(familyMembers, EmployeeFamilyMembersVo.class);
            transService.transBatch(familyMembersVos);
            employeeInfoVo.setFamilyMembers(familyMembersVos);
        }
    }

    /**
     * 批量插入导入数据
     */
    public void insertBatch(List<EmployeeFamilyMembers> list) {
        employeeFamilyMembersMapper.insert(list);
    }
}
