package com.anplus.hr.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cola.dto.PageResponse;
import com.anplus.hr.constant.HrStatusEnum;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.EmployeeRegularReminderListParam;
import com.anplus.hr.domain.params.EmployeeRegularReminderParam;
import com.anplus.hr.domain.vo.EmployeeRegularReminderVo;
import com.anplus.hr.mapper.EmployeeInfoMapper;
import com.anplus.hr.service.EmployeeRegularReminderServ;
import com.anplus.hr.service.EmployeeSysDeptServ;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import top.binfast.common.core.util.MapstructUtils;
import top.binfast.common.mybatis.util.QueryUtil;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * 转正提醒Service业务层处理
 *
 * @author LiuBin
 * @date 2025-11-20
 */
@RequiredArgsConstructor
@Service
public class EmployeeRegularReminderServImpl extends ServiceImpl<EmployeeInfoMapper, EmployeeInfo> implements EmployeeRegularReminderServ {

    private final EmployeeInfoMapper employeeInfoMapper;
    private final EmployeeSysDeptServ employeeSysDeptServ;

    /**
     * 分页查询转正提醒列表
     *
     * @param param 查询条件
     * @return 转正提醒分页列表
     */
    @Override
    public PageResponse<EmployeeRegularReminderVo> queryPageList(EmployeeRegularReminderListParam param) {
        Page<EmployeeInfo> page = QueryUtil.getPage(param);
        LambdaQueryWrapper<EmployeeInfo> lambdaQuery = this.buildQueryWrapper(param);
        employeeInfoMapper.selectPage(page, lambdaQuery);
        return QueryUtil.getPageResponse(page, MapstructUtils.convert(page.getRecords(), EmployeeRegularReminderVo.class));
    }


    /**
     * 查询符合条件的转正提醒列表
     *
     * @param param 查询条件
     * @return 转正提醒列表
     */
    @Override
    public List<EmployeeRegularReminderVo> queryList(EmployeeRegularReminderListParam param) {
        LambdaQueryWrapper<EmployeeInfo> lambdaQuery = this.buildQueryWrapper(param);
        return MapstructUtils.convert(employeeInfoMapper.selectList(lambdaQuery), EmployeeRegularReminderVo.class);
    }

    private LambdaQueryWrapper<EmployeeInfo> buildQueryWrapper(EmployeeRegularReminderListParam param) {
        Map<String, Object> params = param.getParams();
        LambdaQueryWrapper<EmployeeInfo> lambdaQuery = Wrappers.<EmployeeInfo>lambdaQuery();
        lambdaQuery.orderByDesc(EmployeeInfo::getId);
        lambdaQuery.eq(EmployeeInfo::getStatus, HrStatusEnum.ENTRY.getStatus());
        lambdaQuery.between(EmployeeInfo::getExpectedRegularDate, LocalDate.now().minusMonths(1), LocalDate.now().plusMonths(1));
        lambdaQuery.eq(StrUtil.isNotBlank(param.getPlate()), EmployeeInfo::getPlate, param.getPlate());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getFirstLevelDepartment()), EmployeeInfo::getFirstLevelDepartment, param.getFirstLevelDepartment());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getSecondLevelDepartment()), EmployeeInfo::getSecondLevelDepartment, param.getSecondLevelDepartment());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getThirdLevelDepartment()), EmployeeInfo::getThirdLevelDepartment, param.getThirdLevelDepartment());
//        lambdaQuery.eq(param.getDeptId() != null, EmployeeInfo::getDeptId, param.getDeptId());
        if (ObjectUtil.isNotNull(param.getDeptId())) {
            //优先单部门搜索
            lambdaQuery.eq(EmployeeInfo::getDeptId, param.getDeptId());
        } else if (ObjectUtil.isNotNull(param.getBelongDeptId())) {
            //部门树搜索
            lambdaQuery.and(x -> {
                x.in(EmployeeInfo::getDeptId, employeeSysDeptServ.buildQueryWrapper(param.getBelongDeptId()));
            });
        }
        lambdaQuery.eq(StrUtil.isNotBlank(param.getPosition()), EmployeeInfo::getPosition, param.getPosition());
        lambdaQuery.like(StrUtil.isNotBlank(param.getName()), EmployeeInfo::getName, param.getName());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getPhoneNumber()), EmployeeInfo::getPhoneNumber, param.getPhoneNumber());
//        lambdaQuery.eq(param.getEntryDate() != null, EmployeeInfo::getEntryDate, param.getEntryDate());
        lambdaQuery.between(params.get("entryBeginTime") != null && params.get("entryEndTime") != null,
                EmployeeInfo::getEntryDate, params.get("entryBeginTime"), params.get("entryEndTime"));
//        lambdaQuery.eq(param.getExpectedRegularDate() != null, EmployeeInfo::getExpectedRegularDate, param.getExpectedRegularDate());
        lambdaQuery.between(params.get("expectedRegularBeginTime") != null && params.get("expectedRegularEndTime") != null,
                EmployeeInfo::getExpectedRegularDate, params.get("expectedRegularBeginTime"), params.get("expectedRegularEndTime"));
        return lambdaQuery;
    }

    /**
     * 查询转正提醒
     *
     * @param id 主键
     * @return 转正提醒
     */
    @Override
    public EmployeeRegularReminderVo queryById(Long id) {
        EmployeeInfo employeeRegularReminder = employeeInfoMapper.selectById(id);
        return MapstructUtils.convert(employeeRegularReminder, EmployeeRegularReminderVo.class);
    }

    /**
     * 新增转正提醒
     *
     * @param param 转正提醒
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByParam(EmployeeRegularReminderParam param) {
//        EmployeeInfo employeeRegularReminder = MapstructUtils.convert(param, EmployeeInfo.class);
//        return this.save(employeeRegularReminder);
        return true;
    }

    /**
     * 修改转正提醒
     *
     * @param param 转正提醒
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByParam(EmployeeRegularReminderParam param) {
//        EmployeeInfo employeeRegularReminder = MapstructUtils.convert(param, EmployeeInfo.class);
//        return this.updateById(employeeRegularReminder);
        return true;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(EmployeeInfo entity) {
        // 做一些数据校验,如唯一约束
    }

    /**
     * 校验并批量删除转正提醒信息
     *
     * @param ids 待删除的主键集合
     * @return 是否删除成功
     */
    @Override
//    @Transactional(rollbackFor = {Exception.class})
    public Boolean delByIds(List<Long> ids) {
        //做一些业务上的校验,判断是否需要校验
//        return this.removeByIds(ids);
        return true;
    }
}
