package com.anplus.hr.domain.params;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.time.LocalDate;

/**
 * 离职申请参数
 * @author 刘斌
 * @date 2025/10/31 15:48
 */
@Data
public class EmployeeResignApplyParam {

    private Long id;

    /**
     * 员工id
     */
    @NotBlank(message = "员工不能为空")
    private Long employeeId;

    /**
     * 离职类型
     */
    @NotBlank(message = "离职类型不能为空")
    private String resignationType;

    /**
     * 离职类别
     */
    @NotBlank(message = "离职类别不能为空")
    private String resignationCategory;

    /**
     * 离职时间
     */
    @NotNull(message = "离职时间不能为空")
    private LocalDate resignationDate;

    /**
     * 最后结薪日
     */
//    @NotNull(message = "最后结薪日不能为空")
    private LocalDate finalPayDate;

    /**
     * 离职原因
     */
    private String resignationReason;

    private String remark;

}
