package com.anplus.hr.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author 刘斌
 * @date 2025/10/30 16:57
 */
@Getter
@AllArgsConstructor
public enum HrFlowEnum {


    /**
     * 草稿
     */
    DRAFT(0, "草稿"),

    /**
     * 待审核
     */
    WAITING(1, "待审核"),

    /**
     * 已完成
     */
    FINISH(2, "已完成"),

    /**
     * 已撤销
     */
    CANCEL(3, "已撤销");

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, HrFlowEnum> STATUS_MAP = Arrays.stream(HrFlowEnum.values())
            .collect(Collectors.toConcurrentMap(HrFlowEnum::getStatus, Function.identity()));

    public static boolean isNotAbleToApply(Integer status) {
        return status != null && !CANCEL.status.equals(status);
    }
}
