package com.anplus.hr.domain.params;

import lombok.Getter;
import lombok.Setter;
import top.binfast.common.core.bean.params.PageQueryParam;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

/**
 * 员工信息分页对象 employee_info
 *
 * @author LiuBin
 * @date 2025-11-13
 */
@Getter
@Setter
public class EmployeeInfoListParam extends PageQueryParam {

    /**
     * 板块
     */
    private String plate;

    /**
     * 一级部门
     */
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    private Long deptId;

    /**
     * 工号
     */
    private String employeeId;

    /**
     * 职级
     */
    private Integer jobLevel;

    /**
     * 岗位类型
     */
    private String positionType;

    /**
     * 序列
     */
    private String sequence;

    /**
     * 主岗位
     */
    private String position;

    /**
     * 姓名
     */
    private String name;

    /**
     * 性别
     */
    private String gender;

    /**
     * 身份证号码
     */
    private String idCardNumber;

    /**
     * 照片
     */
    private String photo;

    /**
     * 出生日期
     */
    private LocalDate birthDate;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 年龄段
     */
    private String ageGroup;

    /**
     * 兼职板块
     */
    private String partTimePlate;

    /**
     * 兼职一级部门
     */
    private String partTimeFirstDept;

    /**
     * 兼职二级部门
     */
    private String partTimeSecondDept;

    /**
     * 兼职三级部门
     */
    private String partTimeThirdDept;

    /**
     * 兼职岗位
     */
    private String partTimePosition;

    /**
     * 籍贯
     */
    private String nativePlace;

    /**
     * 民族
     */
    private String ethnicity;

    /**
     * 婚姻状况
     */
    private String maritalStatus;

    /**
     * 政治面貌
     */
    private String politicalStatus;

    /**
     * 手机号码
     */
    private String phoneNumber;

    /**
     * 紧急联系人
     */
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    private String homeAddress;

    /**
     * 户口所在地
     */
    private String householdRegistrationAddress;

    /**
     * 参加工作时间
     */
    private LocalDate workStartDate;

    /**
     * 入职时间
     */
    private LocalDate entryDate;

    /**
     * 工龄
     */
    private String yearsOfService;

    /**
     * 工龄段
     */
    private String yearsOfServiceSegment;

    /**
     * 全日制学历
     */
    private String fulltimeEducation;

    /**
     * 全日制毕业院校
     */
    private String fulltimeSchool;

    /**
     * 全日制专业
     */
    private String fulltimeMajor;

    /**
     * 全日制毕业日期
     */
    private LocalDate fulltimeGraduationDate;

    /**
     * 全日制学位
     */
    private String fulltimeDegree;

    /**
     * 非全日制学历
     */
    private String nonFulltimeEducation;

    /**
     * 非全日制毕业院校
     */
    private String nonFulltimeSchool;

    /**
     * 非全日制专业
     */
    private String nonFulltimeMajor;

    /**
     * 非全日制毕业日期
     */
    private LocalDate nonFulltimeGraduationDate;

    /**
     * 非全日制学位
     */
    private String nonFulltimeDegree;

    /**
     * 学历分类
     */
    private String educationCategory;

    /**
     * 员工类型
     */
    private String employeeType;

    /**
     * 职称情况
     */
    private String professionalTitle;

    /**
     * 证书情况
     */
    private String certificateStatus;

    /**
     * 外部个人履历
     */
    private String externalResume;

    /**
     * 内部个人履历
     */
    private String internalResume;

    /**
     * 用工形式
     */
    private String employmentForm;

    /**
     * 合同形式
     */
    private String contractForm;

    /**
     * 劳动合同期限
     */
    private String contractTerm;

    /**
     * 劳动合同开始时间
     */
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
    private LocalDate contractEndDate;

    /**
     * 合同到期提醒
     */
    private LocalDate contractExpirationReminder;

    /**
     * 劳动合同签订情况
     */
    private String contractSigningStatus;

    /**
     * 合同主体
     */
    private String contractEntity;

    /**
     * 社保主体
     */
    private String socialSecurityEntity;

    /**
     * 是否缴纳社保
     */
    private String hasSocialSecurityPaid;

    /**
     * 公积金主体
     */
    private String providentFundEntity;

    /**
     * 是否缴纳公积金
     */
    private String hasProvidentFundPaid;

    /**
     * 试用期（月数）
     */
    private Integer probationPeriod;

    /**
     * 转正时间
     */
    private LocalDate regularizationDate;

    /**
     * 奖励情况
     */
    private String rewardStatus;

    /**
     * 处罚情况
     */
    private String punishmentStatus;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 办公电话
     */
    private String officePhone;

    /**
     * 短线
     */
    private String shortLine;

    /**
     * 银行卡号
     */
    private String bankCardNumber;

    /**
     * 开户行
     */
    private String bankName;

    /**
     * 公司内是否有亲属关系
     */
    private String hasRelativeInCompany;

    /**
     * 亲属姓名
     */
    private String relativeName;

    /**
     * 介绍人
     */
    private String introducer;

    /**
     * 工资发放地
     */
    private String salaryLocation;

    /**
     * 绩效比例
     */
    private String performanceRatio;

    /**
     * 离职类型
     */
    private String resignationType;

    /**
     * 离职时间
     */
    private LocalDate resignationDate;

    /**
     * 离职原因
     */
    private String resignationReason;

    /**
     * 最后结薪日
     */
    private LocalDate finalPayDate;

    /**
     * 员工生命周期状态
     */
    private Integer status;

//    /**
//     * 离职申请状态
//     */
//    private Integer resignationApplyStatus;
//
//    /**
//     * 入职审批状态
//     */
//    private Integer entryApplyStatus;
//
//    /**
//     * 调配申请状态
//     */
//    private Integer transferApplyStatus;


    private Map<String, Object> params = new HashMap<>();

}
