package com.anplus.hr.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author 刘斌
 * @date 2025/11/17 10:59
 */
@Getter
@AllArgsConstructor
public enum HrAgeGroupEnum {

    UNDER_24("1", "24岁以下", 24),
    AGE_25_TO_34("2", "25-34岁", 34),
    AGE_35_TO_44("3", "35-44岁", 44),
    OVER_45("4", "45岁以上", 200);

    private final String code;

    private final String name;

    private final int ageLimit;

    public static HrAgeGroupEnum getByAge(Integer age) {
        if (age == null || age <= 0) {
            return null;
        }
        
        for (HrAgeGroupEnum value : values()) {
            if (age <= value.getAgeLimit()) {
                return value;
            }
        }
        
        return OVER_45;
    }

}
