package com.anplus.hr.service;

import com.alibaba.cola.dto.PageResponse;
import com.baomidou.mybatisplus.extension.service.IService;
import com.anplus.hr.domain.EmployeeDept;
import com.anplus.hr.domain.params.EmployeeDeptCheckAndSaveParam;
import com.anplus.hr.domain.params.EmployeeDeptListParam;
import com.anplus.hr.domain.params.EmployeeDeptParam;
import com.anplus.hr.domain.vo.EmployeeDeptVo;

import java.util.List;

/**
 * 员工部门Service接口
 *
 * @author LiuBin
 * @date 2025-10-30
 */
public interface EmployeeDeptServ extends IService<EmployeeDept> {


    /**
     * 分页查询员工部门列表
     *
     * @param param        查询条件
     * @return 员工部门分页列表
     */
    PageResponse<EmployeeDeptVo> queryPageList(EmployeeDeptListParam param);

    /**
     * 查询符合条件的员工部门列表
     *
     * @param param 查询条件
     * @return 员工部门列表
     */
    List<EmployeeDeptVo> queryList(EmployeeDeptListParam param);

    /**
     * 批量保存部门信息
     *
     * @param param 部门名称
     */
    void checkAndSaveDept(EmployeeDeptCheckAndSaveParam param);

    /**
     * 查询部门名称
     *
     * @param level 部门级别
     * @return 部门名称
     */
    List<String> selectDeptNamesByLevel(Integer level);

    /**
     * 查询部门名称
     *
     * @param parentName 部门名称
     * @return 部门名称
     */
    List<String> selectDeptNamesByParentName(String parentName);

    /**
     * 查询员工部门
     *
     * @param id 主键
     * @return 员工部门
     */
     EmployeeDeptVo queryById(Long id);

    /**
     * 新增员工部门
     *
     * @param param 员工部门
     * @return 是否新增成功
     */
    Boolean insertByParam(EmployeeDeptParam param);

    /**
     * 修改员工部门
     *
     * @param param 员工部门
     * @return 是否修改成功
     */
    Boolean updateByParam(EmployeeDeptParam param);

    /**
     * 校验并批量删除员工部门信息
     *
     * @param ids     待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

}
