package com.anplus.hr.mapper;

import com.anplus.hr.domain.EmployeeFamilyMembers;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import top.binfast.common.mybatis.mapper.BinBaseMapper;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 员工家庭主要成员Mapper接口
 *
 * @author LiuBin
 * @date 2025-12-04
 */
@Mapper
public interface EmployeeFamilyMembersMapper extends BinBaseMapper<EmployeeFamilyMembers> {

    default List<EmployeeFamilyMembers> selectByEmployeeId(Long employeeId) {
        return selectList(new LambdaUpdateWrapper<EmployeeFamilyMembers>()
                .eq(EmployeeFamilyMembers::getEmployeeId, employeeId));
    }

    default int deleteByEmployeeId(Long employeeId) {
        return delete(new LambdaUpdateWrapper<EmployeeFamilyMembers>()
                .eq(EmployeeFamilyMembers::getEmployeeId, employeeId));
    }

}
