package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.domain.EmployeeDept;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;

import java.io.Serial;
import java.io.Serializable;



/**
 * 员工部门视图对象 employee_dept
 *
 * @author LiuBin
 * @date 2025-10-30
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = EmployeeDept.class)
public class EmployeeDeptVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 父级部门
     */
    private Long parentId;


    /**
     * 父级部门名称
     */
    @ExcelProperty(value = "父级部门")
    private String parentName;

    /**
     * 部门名称
     */
    @ExcelProperty(value = "部门名称")
    private String name;

    /**
     * 部门层级
     */
    private Integer level;

    /**
     * 祖级关系
     */
    @ExcelProperty(value = "祖级关系")
    private String nodePath;

    /**
     * 显示顺序
     */
    @ExcelProperty(value = "显示顺序")
    private Long orderNum;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "SYS_COMMON_STATUS")
    private Integer status;


}
