package com.anplus.hr.domain.params;

import com.anplus.hr.domain.EmployeeInfo;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import jakarta.validation.constraints.*;
import java.time.LocalDate;

/**
 * 兼职员工信息业务对象 employee_part_time_info
 *
 * @author LiuBin
 * @date 2025-12-10
 */
@Data
@AutoMapper(target = EmployeeInfo.class, reverseConvertGenerate = false)
public class EmployeePartTimeInfoParam {

    /**
     * 序号
     */
    @NotNull(message = "序号不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 板块
     */
    @NotBlank(message = "板块不能为空", groups = { AddGroup.class, EditGroup.class })
    private String plate;

    /**
     * 一级部门
     */
    @NotBlank(message = "一级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @NotBlank(message = "二级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    @NotBlank(message = "三级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    @NotNull(message = "部门ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long deptId;

    /**
     * 岗位类型
     */
//    @NotBlank(message = "岗位类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String positionType;

    /**
     * 主岗位
     */
    @NotBlank(message = "主岗位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String position;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 性别
     */
    @NotBlank(message = "性别不能为空", groups = { AddGroup.class, EditGroup.class })
    private String gender;

    /**
     * 身份证号码
     */
    @NotBlank(message = "身份证号码不能为空", groups = { AddGroup.class, EditGroup.class })
    private String idCardNumber;

    /**
     * 照片ID
     */
//    @NotNull(message = "照片ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long ossId;

    /**
     * 出生日期
     */
    @NotNull(message = "出生日期不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate birthDate;

    /**
     * 年龄
     */
    @NotNull(message = "年龄不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer age;

    /**
     * 籍贯
     */
//    @NotBlank(message = "籍贯不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nativePlace;

    /**
     * 民族
     */
//    @NotBlank(message = "民族不能为空", groups = { AddGroup.class, EditGroup.class })
    private String ethnicity;

    /**
     * 婚姻状况
     */
//    @NotBlank(message = "婚姻状况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String maritalStatus;

    /**
     * 政治面貌
     */
//    @NotBlank(message = "政治面貌不能为空", groups = { AddGroup.class, EditGroup.class })
    private String politicalStatus;

    /**
     * 手机号码
     */
    @NotBlank(message = "手机号码不能为空", groups = { AddGroup.class, EditGroup.class })
    private String phoneNumber;

    /**
     * 紧急联系人
     */
//    @NotBlank(message = "紧急联系人不能为空", groups = { AddGroup.class, EditGroup.class })
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
//    @NotBlank(message = "紧急联系人电话不能为空", groups = { AddGroup.class, EditGroup.class })
    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    @NotBlank(message = "家庭地址不能为空", groups = { AddGroup.class, EditGroup.class })
    private String homeAddress;

    /**
     * 入职时间
     */
//    @NotNull(message = "入职时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate entryDate;

    /**
     * 全日制学历
     */
//    @NotBlank(message = "全日制学历不能为空", groups = { AddGroup.class, EditGroup.class })
    private String fulltimeEducation;

    /**
     * 全日制毕业院校
     */
//    @NotBlank(message = "全日制毕业院校不能为空", groups = { AddGroup.class, EditGroup.class })
    private String fulltimeSchool;

    /**
     * 全日制专业
     */
//    @NotBlank(message = "全日制专业不能为空", groups = { AddGroup.class, EditGroup.class })
    private String fulltimeMajor;

    /**
     * 全日制毕业日期
     */
//    @NotNull(message = "全日制毕业日期不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate fulltimeGraduationDate;

    /**
     * 全日制学位
     */
//    @NotBlank(message = "全日制学位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String fulltimeDegree;

    /**
     * 用工形式
     */
//    @NotBlank(message = "用工形式不能为空", groups = { AddGroup.class, EditGroup.class })
    private String employmentForm;

    /**
     * 是否兼职
     */
//    @NotBlank(message = "是否兼职不能为空", groups = { AddGroup.class, EditGroup.class })
    private String partTimeFlag;

    /**
     * 签订兼职协议
     */
//    @NotBlank(message = "兼职协议不能为空", groups = { AddGroup.class, EditGroup.class })
    private String partTimeAgreement;

    /**
     * 协议主体
     */
//    @NotBlank(message = "协议主体不能为空", groups = { AddGroup.class, EditGroup.class })
    private String agreementEntity;

    /**
     * 协议期限
     */
//    @NotBlank(message = "协议期限不能为空", groups = { AddGroup.class, EditGroup.class })
    private String agreementPeriod;

    /**
     * 协议开始时间
     */
//    @NotNull(message = "协议开始时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate agreementStartDate;

    /**
     * 协议截止时间
     */
//    @NotNull(message = "协议截止时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate agreementEndDate;

    /**
     * 备注
     */
//    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remarks;

    /**
     * 银行卡号
     */
//    @NotBlank(message = "银行卡号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String bankCardNumber;

    /**
     * 开户行
     */
//    @NotBlank(message = "开户行不能为空", groups = { AddGroup.class, EditGroup.class })
    private String bankName;

    /**
     * 公司内是否有亲属关系
     */
//    @NotBlank(message = "公司内是否有亲属关系不能为空", groups = { AddGroup.class, EditGroup.class })
    private String hasRelativeInCompany;

    /**
     * 亲属姓名
     */
//    @NotBlank(message = "亲属姓名不能为空", groups = { AddGroup.class, EditGroup.class })
    private String relativeName;

    /**
     * 介绍人
     */
//    @NotBlank(message = "介绍人不能为空", groups = { AddGroup.class, EditGroup.class })
    private String introducer;

    /**
     * 介绍人关系
     */
//    @NotBlank(message = "介绍人关系不能为空", groups = { AddGroup.class, EditGroup.class })
    private String introducerRelation;

    /**
     * 工资发放地
     */
//    @NotBlank(message = "工资发放地不能为空", groups = { AddGroup.class, EditGroup.class })
    private String salaryLocation;

    /**
     * 成本费用所属
     */
//    @NotBlank(message = "成本费用所属不能为空", groups = { AddGroup.class, EditGroup.class })
    private String costOfDept;


}
