package com.anplus.hr.config;

import cn.idev.excel.event.Order;
import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.write.handler.CellWriteHandler;
import cn.idev.excel.write.handler.context.CellWriteHandlerContext;
import cn.idev.excel.write.metadata.style.WriteCellStyle;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ResumeTemplateStyleHandler implements CellWriteHandler, Order {
    @Override
    public void afterCellDispose(CellWriteHandlerContext context) {
        // 1. 获取当前单元格和它对应的“第一个单元格数据”（通常承载了模板的原始样式）
        Cell cell = context.getCell();
        WriteCellData cellData = context.getFirstCellData();

        // 2. 如果模板单元格有样式，则将其应用到当前单元格
        if (cellData != null) {
            WriteCellStyle writeCellStyle = cellData.getWriteCellStyle();
            if (writeCellStyle != null) {
                // 使用EasyExcel的工具类安全地转换并设置样式
//                CellStyle style = StyleUtil.buildCellStyle(
//                        context.getWriteWorkbookHolder().getWorkbook(),
//                        writeCellStyle,
//                        originalStyle
//                );
                Workbook workbook = context.getWriteWorkbookHolder().getWorkbook();
                CellStyle cellStyle = workbook.createCellStyle();
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                cellStyle.setBorderBottom(BorderStyle.THIN);
                cellStyle.setBorderLeft(BorderStyle.THIN);
                cellStyle.setBorderRight(BorderStyle.THIN);
                cellStyle.setBorderTop(BorderStyle.THIN);
//                String content = cell.getStringCellValue();
//                XSSFRichTextString text = new XSSFRichTextString(content);
//                cell.setCellValue(text);
                Font font = workbook.createFont();
                font.setFontName("微软雅黑");
                font.setFontHeightInPoints((short) 10);
                cellStyle.setFont(font);
                cell.setCellStyle(cellStyle);
            }
        }
    }

    // 3. 关键：设置order值大于50000，确保本处理器在默认的FillStyleCellWriteHandler之后执行
    @Override
    public int order() {
        return 50001;
    }
}