package com.anplus.hr.service.impl.command;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import lombok.RequiredArgsConstructor;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import top.binfast.app.biz.sysapi.bean.model.auth.SysRole;
import top.binfast.app.biz.sysapi.dao.auth.SysRoleMapper;
import top.binfast.app.biz.sysapi.dao.auth.SysUserRoleMapper;
import top.binfast.common.sse.dto.SseMessageDto;
import top.binfast.common.sse.utils.SseMessageUtils;

import java.util.List;

/**
 * @author 刘斌
 * @date 2025/12/16 20:08
 */
@Component
@RequiredArgsConstructor
public class SendMessageCmdExe {

    private final SysRoleMapper sysRoleMapper;
    private final SysUserRoleMapper sysUserRoleMapper;

    /**
     * 发送消息给管理员
     * 标识：hr_admin
     *
     * @param message 消息
     */
    @Async
    public void sendMessageToAdmin(String message) {
        SysRole hrAdmin = sysRoleMapper.selectOne(new LambdaUpdateWrapper<SysRole>()
                .eq(SysRole::getRoleKey, "hr_admin"));
        if (hrAdmin == null) {
            return;
        }
        List<Long> userIdList = sysUserRoleMapper.selectUserIdsByRoleId(hrAdmin.getId());
        if (CollUtil.isEmpty(userIdList)) {
            return;
        }
        SseMessageDto dto = new SseMessageDto();
        dto.setUserIds(userIdList);
        dto.setMessage(message);
        SseMessageUtils.publishMessage(dto);
    }
}
