package com.anplus.hr.service;

import com.alibaba.cola.dto.PageResponse;
import com.alibaba.cola.dto.Response;
import com.anplus.hr.domain.EmployeeTraining;
import com.anplus.hr.domain.params.EmployeeTrainingListParam;
import com.anplus.hr.domain.params.EmployeeTrainingParam;
import com.anplus.hr.domain.vo.EmployeeTrainingImportVo;
import com.anplus.hr.domain.vo.EmployeeTrainingVo;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;
import java.util.stream.Stream;

/**
 * 员工培训档案Service接口
 *
 * @author LiuBin
 * @date 2025-12-07
 */
public interface EmployeeTrainingServ extends IService<EmployeeTraining> {


    /**
     * 分页查询员工培训档案列表
     *
     * @param param 查询条件
     * @return 员工培训档案分页列表
     */
    PageResponse<EmployeeTrainingVo> queryPageList(EmployeeTrainingListParam param);

    /**
     * 查询符合条件的员工培训档案列表
     *
     * @param param 查询条件
     * @return 员工培训档案列表
     */
    List<EmployeeTrainingVo> queryList(EmployeeTrainingListParam param);

    /**
     * 导入员工培训档案列表
     *
     * @param list 员工培训档案列表
     * @return 是否导入成功
     */
    Response importTrainingList(Stream<EmployeeTrainingImportVo> list);

    /**
     * 查询员工培训档案
     *
     * @param id 主键
     * @return 员工培训档案
     */
    EmployeeTrainingVo queryById(Long id);

    /**
     * 新增员工培训档案
     *
     * @param param 员工培训档案
     * @return 是否新增成功
     */
    Boolean insertByParam(EmployeeTrainingParam param);

    /**
     * 修改员工培训档案
     *
     * @param param 员工培训档案
     * @return 是否修改成功
     */
    Boolean updateByParam(EmployeeTrainingParam param);

    /**
     * 校验并批量删除员工培训档案信息
     *
     * @param ids 待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

}
