package com.anplus.hr.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cola.dto.PageResponse;
import com.alibaba.cola.dto.Response;
import com.anplus.hr.domain.EmployeeFamilyMembers;
import com.anplus.hr.domain.vo.EmployeeFlowVo;
import com.anplus.hr.domain.vo.EmployeeInfoResumeVo;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.*;
import com.anplus.hr.domain.vo.EmployeeInfoImportVo;
import com.anplus.hr.domain.vo.EmployeeInfoVo;
import org.springframework.web.multipart.MultipartFile;
import top.binfast.app.biz.sysapi.bean.model.oss.SysOss;
import top.binfast.app.biz.sysapi.bean.vo.sysOss.SysOssVo;
import top.binfast.common.excel.image.CellImageData;
import top.binfast.common.excel.image.ExcelProcessingResult;
import top.binfast.common.oss.entity.UploadResult;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

/**
 * 员工信息Service接口
 *
 * @author LiuBin
 * @date 2025-10-28
 */
public interface EmployeeInfoServ extends IService<EmployeeInfo> {


    /**
     * 分页查询员工信息列表
     *
     * @param param        查询条件
     * @return 员工信息分页列表
     */
    PageResponse<EmployeeInfoVo> queryPageList(EmployeeInfoListParam param);

    /**
     * 查询符合条件的员工信息列表
     *
     * @param param 查询条件
     * @return 员工信息列表
     */
    List<EmployeeInfoVo> queryList(EmployeeInfoListParam param);

    /**
     * 构建查询条件
     *
     * @param param 查询条件
     * @return 查询条件
     */
    LambdaQueryWrapper<EmployeeInfo> buildQueryWrapper(EmployeeInfoListParam param);

    /**
     * 导入员工信息列表
     *
     * @param stream 员工信息列表
     * @return 是否导入成功
     */
    Response importEmployeeList(Stream<EmployeeInfoImportVo> stream, MultipartFile file);

    /**
     * 校验员工名称是否唯一
     *
     * @param idCardNumber 员工身份证号
     * @param employeeId 员工主键
     * @return 是否唯一
     */
    Boolean checkEmployeeIdCardNumberUnique(String idCardNumber, Long employeeId);
    /**
     * 查询员工信息
     *
     * @param id 主键
     * @return 员工信息
     */
     EmployeeInfoVo queryById(Long id);

     /**
     * 员工信息详情
     *
     * @param id 主键
     * @return 员工信息
     */
     EmployeeInfoVo infoDetail(Long id);

     /**
     * 导出简历用：员工信息详情
     *
     * @param id 主键
     * @return 员工信息
     */
    EmployeeInfoResumeVo infoDetailForResume(Long id);

    /**
     * 新增员工信息
     *
     * @param param 员工信息
     * @return 是否新增成功
     */
    Boolean insertByParam(EmployeeInfoParam param);

    /**
     * 新增基础员工信息
     *
     * @param param 员工信息
     * @return 是否新增成功
     */
    Boolean insertBaseInfoForH5(EmployeeBaseInfoParam param);

    /**
     * 修改员工信息
     *
     * @param param 员工信息
     * @return 是否修改成功
     */
    Boolean updateByParam(EmployeeInfoParam param);

    /**
     * 员工入职申请
     *
     * @param param 参数
     */
    EmployeeFlowVo applyEntry(EmployeeEntryApplyParam param);

    /**
     * 员工调职申请
     *
     * @param param 参数
     */
    EmployeeFlowVo applyTransfer(EmployeeTransferApplyParam param);

    /**
     * 员工离职申请
     *
     * @param param 参数
     */
    EmployeeFlowVo applyResign(EmployeeResignApplyParam param);

    /**
     * 员工转正申请
     *
     * @param param 参数
     */
    EmployeeFlowVo applyRegular(EmployeeRegularApplyParam param);

    /**
     * 员工续签合同申请
     *
     * @param param 参数
     */
    EmployeeFlowVo applyRenewalContract(EmployeeRenewalContractApplyParam param);

    /**
     * 校验并批量删除员工信息信息
     *
     * @param ids     待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

    /**
     * 处理图片上传结果
     *
     * @param excelProcessingResult excel处理结果
     * @param importVo              导入数据
     */
    SysOss handleImageToUrl(ExcelProcessingResult excelProcessingResult, EmployeeInfoImportVo importVo);

    /**
     * 上传 MultipartFile 到对象存储服务，并保存文件信息到数据库
     *
     * @param file 要上传的 MultipartFile 对象
     * @return 上传成功后的 SysOssVo 对象，包含文件信息
     */
    SysOssVo upload(MultipartFile file);

    /**
     * 构建员工家庭成员列表
     * 按照【关系 姓名 出生年月 工作单位职务 联系方式】格式
     * 用空格区分属性，用；区分人员
     * @param familyMembersImportStr 员工家庭成员字符串
     * @return 员工家庭成员列表
     */
    default List<EmployeeFamilyMembers> buildFamilyMembers(String familyMembersImportStr) {
        List<EmployeeFamilyMembers> familyMembers = new ArrayList<>();
        if (StrUtil.isNotBlank(familyMembersImportStr)) {
            String[] list = familyMembersImportStr.split("；");
            for (String memberProp : list) {
                EmployeeFamilyMembers member = new EmployeeFamilyMembers();
                String[] split = memberProp.split(StrUtil.SPACE);
                if (split.length != 5) {
                    continue;
                }
                member.setRelation(split[0]);
                member.setName(split[1]);
                member.setBirthDate(split[2]);
                member.setCompanyAndJob(split[3]);
                member.setContact(split[4]);
                familyMembers.add(member);
            }
        }
        return familyMembers;
    }

}
