package com.anplus.hr.mapper;

import com.anplus.hr.domain.EmployeeFlow;
import com.anplus.hr.domain.vo.EmployeeFlowVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import top.binfast.common.mybatis.datascope.annotation.DataColumn;
import top.binfast.common.mybatis.datascope.annotation.DataPermission;
import top.binfast.common.mybatis.datascope.core.DeptDataScope;
import top.binfast.common.mybatis.mapper.BinBaseMapper;

import java.util.List;

/**
 * 人事审批对象Mapper接口
 *
 * @author LiuBin
 * @date 2025-10-31
 */
@Mapper
public interface EmployeeFlowMapper extends BinBaseMapper<EmployeeFlow> {

    @DataPermission(type = DeptDataScope.DATA_SCOPE_TYPE, value = {
            @DataColumn(key = DeptDataScope.DEPT_DATA_SCOPE_KEY, value = "e.dept_id"),
            @DataColumn(key = DeptDataScope.USER_DATA_SCOPE_KEY, value = "f.create_by")
    })
    Page<EmployeeFlowVo> selectPageVo(@Param("page") Page<EmployeeFlow> page, @Param(Constants.WRAPPER) Wrapper<EmployeeFlow> queryWrapper);

    @DataPermission(type = DeptDataScope.DATA_SCOPE_TYPE, value = {
            @DataColumn(key = DeptDataScope.DEPT_DATA_SCOPE_KEY, value = "e.dept_id"),
            @DataColumn(key = DeptDataScope.USER_DATA_SCOPE_KEY, value = "f.create_by")
    })
    List<EmployeeFlowVo> selectListVo(@Param(Constants.WRAPPER) Wrapper<EmployeeFlow> queryWrapper);

}
