package com.anplus.hr.domain.vo;

import com.anplus.hr.domain.StaffingPlanRecords;
import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import cn.idev.excel.annotation.ExcelIgnore;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;



/**
 * 编制规划记录视图对象 staffing_plan_records
 *
 * @author LiuBin
 * @date 2025-12-14
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = StaffingPlanRecords.class)
public class StaffingPlanRecordsVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 记录时间
     */
    @ExcelProperty(value = "记录时间")
    private String recordDate;

    /**
     * 上一年标题
     */
    @ExcelProperty(value = "上一年标题")
    private String lastYearTitle;

    /**
     * 今年标题
     */
    @ExcelProperty(value = "今年标题")
    private String currentYearTitle;

    /**
     * 明年标题
     */
    @ExcelProperty(value = "明年标题")
    private String nextYearTitle;

    /**
     * 是否已初始化
     */
    @ExcelProperty(value = "是否已初始化")
    private String initFlag;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


}
