package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.domain.StaffingPlanRecords;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.util.List;

/**
 * @author 刘斌
 * @date 2025/12/15 19:54
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = StaffingPlanRecords.class, convertGenerate = false)
public class StaffingPlanExportVo {

    /**
     * 上一年标题
     */
    @ExcelProperty(value = "上一年标题")
    private String lastYearTitle;

    /**
     * 今年标题
     */
    @ExcelProperty(value = "今年标题")
    private String currentYearTitle;

    /**
     * 明年标题
     */
    @ExcelProperty(value = "明年标题")
    private String nextYearTitle;

    /**
     * 编制明细
     */
    @ExcelProperty(value = "编制明细")
    private List<StaffingPlanDataVo> dataList;
}
