package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.constant.HrConstant;
import com.anplus.hr.domain.EmployeeChangeLog;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;



/**
 * 员工变动记录视图对象 employee_change_log
 *
 * @author LiuBin
 * @date 2025-11-24
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = EmployeeChangeLog.class)
public class EmployeeChangeLogVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 变动类型
     */
    @ExcelProperty(value = "变动类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_CHANGE_LOG_TYPE)
    private String type;

    /**
     * 流程申请编号
     */
    @ExcelProperty(value = "流程申请编号")
    private String applyCode;

    /**
     * 板块ID
     */
    @ExcelProperty(value = "板块ID")
    private Long plateId;

    /**
     * 板块
     */
    @ExcelProperty(value = "板块")
    private String plate;

    /**
     * 部门ID
     */
    @ExcelProperty(value = "部门ID")
    private Long deptId;

    /**
     * 员工ID
     */
    @ExcelProperty(value = "员工ID")
    private Long employeeId;

    /**
     * 变动时间
     */
    @ExcelProperty(value = "变动时间")
    private LocalDate changeDate;

    /**
     * 离职类型
     */
    @ExcelProperty(value = "离职类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_RESIGNATION_TYPE)
    private String resignType;

    /**
     * 离职工龄类型
     */
    @ExcelProperty(value = "离职工龄类型", converter = ExcelDictConvert.class)
//    @ExcelDictFormat(dictType = HrConstant.HR_RESIGN_YEARS_OF_SERVICE_TYPE)
    private String resignYearsOfServiceType;


}
