package com.anplus.hr.domain.params;

import lombok.Getter;
import lombok.Setter;
import top.binfast.common.core.bean.params.PageQueryParam;
import java.util.HashMap;
import java.util.Map;
import java.time.LocalDate;

/**
 * 面试档案分页对象 interview_profile
 *
 * @author LiuBin
 * @date 2025-12-08
 */
@Getter
@Setter
public class InterviewProfileListParam extends PageQueryParam {

    /**
     * 员工信息ID
     */
    private Long employeeId;

    /**
     * 招揽岗位
     */
    private String jobPosition;

    /**
     * 姓名
     */
    private String name;

    /**
     * 性别
     */
    private String gender;

    /**
     * 身份证号
     */
    private String idCardNumber;

    /**
     * 学历
     */
    private String education;

    /**
     * 院校
     */
    private String school;

    /**
     * 专业
     */
    private String major;

    /**
     * 联系方式
     */
    private String phoneNumber;

    /**
     * 标杆企业
     */
    private String benchmarkEnterprise;

    /**
     * 面试时间
     */
    private LocalDate interviewDate;

    /**
     * 面试情况
     */
    private String interviewSituation;

    /**
     * 面试结果
     */
    private String interviewResult;


    private Map<String, Object> params = new HashMap<>();

}
