package com.anplus.hr.domain.params;

import lombok.Getter;
import lombok.Setter;
import top.binfast.common.core.bean.params.PageQueryParam;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

/**
 * 员工培训档案分页对象 employee_training
 *
 * @author LiuBin
 * @date 2025-12-07
 */
@Getter
@Setter
public class EmployeeTrainingListParam extends PageQueryParam {

    /**
     * 员工信息ID
     */
    private Long employeeId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 身份证号
     */
    private String idCardNumber;

    /**
     * 培训课程
     */
    private String trainingCourse;

    /**
     * 培训机构
     */
    private String trainingInstitution;

    /**
     * 培训讲师
     */
    private String trainer;

    /**
     * 参训时间
     */
    private LocalDate trainingTime;

    /**
     * 服务期
     */
    private LocalDate serviceEndDate;

    /**
     * 服务年限
     */
    private String serviceYears;

    /**
     * 培训金额
     */
    private BigDecimal trainingAmount;


    private Map<String, Object> params = new HashMap<>();

}
